/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;

public class ObjectIdentifierUnmarshaller
implements Unmarshaller<ObjectIdentifier, StaxUnmarshallerContext> {
    private static ObjectIdentifierUnmarshaller INSTANCE;

    @Override
    public ObjectIdentifier unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ObjectIdentifier.Builder objectIdentifier = ObjectIdentifier.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Key", targetDepth)) {
                    objectIdentifier.key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("VersionId", targetDepth)) continue;
                objectIdentifier.versionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ObjectIdentifier)objectIdentifier.build();
    }

    public static ObjectIdentifierUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ObjectIdentifierUnmarshaller();
        }
        return INSTANCE;
    }
}

