/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.ObjectVersion;
import software.amazon.awssdk.services.s3.transform.OwnerUnmarshaller;

public class ObjectVersionUnmarshaller
implements Unmarshaller<ObjectVersion, StaxUnmarshallerContext> {
    private static ObjectVersionUnmarshaller INSTANCE;

    @Override
    public ObjectVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ObjectVersion.Builder objectVersion = ObjectVersion.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ETag", targetDepth)) {
                    objectVersion.eTag(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Size", targetDepth)) {
                    objectVersion.size(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StorageClass", targetDepth)) {
                    objectVersion.storageClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Key", targetDepth)) {
                    objectVersion.key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VersionId", targetDepth)) {
                    objectVersion.versionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsLatest", targetDepth)) {
                    objectVersion.isLatest(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastModified", targetDepth)) {
                    objectVersion.lastModified(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Owner", targetDepth)) continue;
                objectVersion.owner(OwnerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ObjectVersion)objectVersion.build();
    }

    public static ObjectVersionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ObjectVersionUnmarshaller();
        }
        return INSTANCE;
    }
}

