/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.StringWriter;
import java.util.List;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.CORSConfiguration;
import software.amazon.awssdk.services.s3.model.CORSRule;
import software.amazon.awssdk.services.s3.model.PutBucketCorsRequest;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketCorsRequestMarshaller
implements Marshaller<Request<PutBucketCorsRequest>, PutBucketCorsRequest> {
    @Override
    public Request<PutBucketCorsRequest> marshall(PutBucketCorsRequest putBucketCorsRequest) {
        if (putBucketCorsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutBucketCorsRequest> request = new DefaultRequest<PutBucketCorsRequest>(putBucketCorsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketCorsRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putBucketCorsRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?cors";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketCorsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            CORSConfiguration corsConfiguration = putBucketCorsRequest.corsConfiguration();
            if (corsConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("CORSConfiguration");
                List<CORSRule> cORSConfigurationCORSRulesList = corsConfiguration.corsRules();
                if (cORSConfigurationCORSRulesList != null) {
                    for (CORSRule cORSConfigurationCORSRulesListValue : cORSConfigurationCORSRulesList) {
                        List<String> cORSRuleExposeHeadersList;
                        List<String> list;
                        List<String> cORSRuleAllowedMethodsList;
                        xmlWriter.startElement("CORSRule");
                        List<String> cORSRuleAllowedHeadersList = cORSConfigurationCORSRulesListValue.allowedHeaders();
                        if (cORSRuleAllowedHeadersList != null) {
                            for (String string : cORSRuleAllowedHeadersList) {
                                xmlWriter.startElement("AllowedHeader");
                                xmlWriter.value(string);
                                xmlWriter.endElement();
                            }
                        }
                        if ((cORSRuleAllowedMethodsList = cORSConfigurationCORSRulesListValue.allowedMethods()) != null) {
                            for (Object cORSRuleAllowedMethodsListValue : cORSRuleAllowedMethodsList) {
                                xmlWriter.startElement("AllowedMethod");
                                xmlWriter.value((String)cORSRuleAllowedMethodsListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if ((list = cORSConfigurationCORSRulesListValue.allowedOrigins()) != null) {
                            Object cORSRuleAllowedMethodsListValue;
                            cORSRuleAllowedMethodsListValue = list.iterator();
                            while (cORSRuleAllowedMethodsListValue.hasNext()) {
                                String cORSRuleAllowedOriginsListValue = (String)cORSRuleAllowedMethodsListValue.next();
                                xmlWriter.startElement("AllowedOrigin");
                                xmlWriter.value(cORSRuleAllowedOriginsListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if ((cORSRuleExposeHeadersList = cORSConfigurationCORSRulesListValue.exposeHeaders()) != null) {
                            for (String cORSRuleExposeHeadersListValue : cORSRuleExposeHeadersList) {
                                xmlWriter.startElement("ExposeHeader");
                                xmlWriter.value(cORSRuleExposeHeadersListValue);
                                xmlWriter.endElement();
                            }
                        }
                        if (cORSConfigurationCORSRulesListValue.maxAgeSeconds() != null) {
                            xmlWriter.startElement("MaxAgeSeconds").value(cORSConfigurationCORSRulesListValue.maxAgeSeconds()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

