/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.StringWriter;
import java.util.List;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.InventoryConfiguration;
import software.amazon.awssdk.services.s3.model.InventoryDestination;
import software.amazon.awssdk.services.s3.model.InventoryFilter;
import software.amazon.awssdk.services.s3.model.InventoryS3BucketDestination;
import software.amazon.awssdk.services.s3.model.InventorySchedule;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketInventoryConfigurationRequestMarshaller
implements Marshaller<Request<PutBucketInventoryConfigurationRequest>, PutBucketInventoryConfigurationRequest> {
    @Override
    public Request<PutBucketInventoryConfigurationRequest> marshall(PutBucketInventoryConfigurationRequest putBucketInventoryConfigurationRequest) {
        if (putBucketInventoryConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutBucketInventoryConfigurationRequest> request = new DefaultRequest<PutBucketInventoryConfigurationRequest>(putBucketInventoryConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{Bucket}?inventory";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketInventoryConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (putBucketInventoryConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString(putBucketInventoryConfigurationRequest.id()));
        }
        try {
            StringWriter stringWriter = null;
            InventoryConfiguration inventoryConfiguration = putBucketInventoryConfigurationRequest.inventoryConfiguration();
            if (inventoryConfiguration != null) {
                InventorySchedule schedule;
                List<String> inventoryConfigurationOptionalFieldsList;
                InventoryFilter filter;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("InventoryConfiguration");
                InventoryDestination destination = inventoryConfiguration.destination();
                if (destination != null) {
                    xmlWriter.startElement("Destination");
                    InventoryS3BucketDestination s3BucketDestination = destination.s3BucketDestination();
                    if (s3BucketDestination != null) {
                        xmlWriter.startElement("S3BucketDestination");
                        if (s3BucketDestination.accountId() != null) {
                            xmlWriter.startElement("AccountId").value(s3BucketDestination.accountId()).endElement();
                        }
                        if (s3BucketDestination.bucket() != null) {
                            xmlWriter.startElement("Bucket").value(s3BucketDestination.bucket()).endElement();
                        }
                        if (s3BucketDestination.format() != null) {
                            xmlWriter.startElement("Format").value(s3BucketDestination.format()).endElement();
                        }
                        if (s3BucketDestination.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(s3BucketDestination.prefix()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (inventoryConfiguration.isEnabled() != null) {
                    xmlWriter.startElement("IsEnabled").value(inventoryConfiguration.isEnabled()).endElement();
                }
                if ((filter = inventoryConfiguration.filter()) != null) {
                    xmlWriter.startElement("Filter");
                    if (filter.prefix() != null) {
                        xmlWriter.startElement("Prefix").value(filter.prefix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (inventoryConfiguration.id() != null) {
                    xmlWriter.startElement("Id").value(inventoryConfiguration.id()).endElement();
                }
                if (inventoryConfiguration.includedObjectVersions() != null) {
                    xmlWriter.startElement("IncludedObjectVersions").value(inventoryConfiguration.includedObjectVersions()).endElement();
                }
                if ((inventoryConfigurationOptionalFieldsList = inventoryConfiguration.optionalFields()) != null) {
                    xmlWriter.startElement("OptionalFields");
                    for (String inventoryConfigurationOptionalFieldsListValue : inventoryConfigurationOptionalFieldsList) {
                        xmlWriter.startElement("Field");
                        xmlWriter.value(inventoryConfigurationOptionalFieldsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((schedule = inventoryConfiguration.schedule()) != null) {
                    xmlWriter.startElement("Schedule");
                    if (schedule.frequency() != null) {
                        xmlWriter.startElement("Frequency").value(schedule.frequency()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

