/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.StringWriter;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketRequestPaymentRequestMarshaller
implements Marshaller<Request<PutBucketRequestPaymentRequest>, PutBucketRequestPaymentRequest> {
    @Override
    public Request<PutBucketRequestPaymentRequest> marshall(PutBucketRequestPaymentRequest putBucketRequestPaymentRequest) {
        if (putBucketRequestPaymentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutBucketRequestPaymentRequest> request = new DefaultRequest<PutBucketRequestPaymentRequest>(putBucketRequestPaymentRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketRequestPaymentRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putBucketRequestPaymentRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?requestPayment";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketRequestPaymentRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            RequestPaymentConfiguration requestPaymentConfiguration = putBucketRequestPaymentRequest.requestPaymentConfiguration();
            if (requestPaymentConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("RequestPaymentConfiguration");
                if (requestPaymentConfiguration.payer() != null) {
                    xmlWriter.startElement("Payer").value(requestPaymentConfiguration.payer()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

