/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.StringWriter;
import java.util.List;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Tagging;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketTaggingRequestMarshaller
implements Marshaller<Request<PutBucketTaggingRequest>, PutBucketTaggingRequest> {
    @Override
    public Request<PutBucketTaggingRequest> marshall(PutBucketTaggingRequest putBucketTaggingRequest) {
        if (putBucketTaggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutBucketTaggingRequest> request = new DefaultRequest<PutBucketTaggingRequest>(putBucketTaggingRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketTaggingRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putBucketTaggingRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?tagging";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketTaggingRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            Tagging tagging = putBucketTaggingRequest.tagging();
            if (tagging != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("Tagging");
                List<Tag> taggingTagSetList = tagging.tagSet();
                if (taggingTagSetList != null) {
                    xmlWriter.startElement("TagSet");
                    for (Tag taggingTagSetListValue : taggingTagSetList) {
                        xmlWriter.startElement("Tag");
                        if (taggingTagSetListValue.key() != null) {
                            xmlWriter.startElement("Key").value(taggingTagSetListValue.key()).endElement();
                        }
                        if (taggingTagSetListValue.value() != null) {
                            xmlWriter.startElement("Value").value(taggingTagSetListValue.value()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

