/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.StringWriter;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.VersioningConfiguration;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutBucketVersioningRequestMarshaller
implements Marshaller<Request<PutBucketVersioningRequest>, PutBucketVersioningRequest> {
    @Override
    public Request<PutBucketVersioningRequest> marshall(PutBucketVersioningRequest putBucketVersioningRequest) {
        if (putBucketVersioningRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutBucketVersioningRequest> request = new DefaultRequest<PutBucketVersioningRequest>(putBucketVersioningRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketVersioningRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putBucketVersioningRequest.contentMD5()));
        }
        if (putBucketVersioningRequest.mfa() != null) {
            request.addHeader("x-amz-mfa", StringUtils.fromString(putBucketVersioningRequest.mfa()));
        }
        String uriResourcePath = "/{Bucket}?versioning";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketVersioningRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            VersioningConfiguration versioningConfiguration = putBucketVersioningRequest.versioningConfiguration();
            if (versioningConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("VersioningConfiguration");
                if (versioningConfiguration.mfaDelete() != null) {
                    xmlWriter.startElement("MfaDelete").value(versioningConfiguration.mfaDelete()).endElement();
                }
                if (versioningConfiguration.status() != null) {
                    xmlWriter.startElement("Status").value(versioningConfiguration.status()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

