/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.StringWriter;
import java.util.List;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.AccessControlPolicy;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.model.Grantee;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class PutObjectAclRequestMarshaller
implements Marshaller<Request<PutObjectAclRequest>, PutObjectAclRequest> {
    @Override
    public Request<PutObjectAclRequest> marshall(PutObjectAclRequest putObjectAclRequest) {
        if (putObjectAclRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutObjectAclRequest> request = new DefaultRequest<PutObjectAclRequest>(putObjectAclRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putObjectAclRequest.acl() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString(putObjectAclRequest.acl()));
        }
        if (putObjectAclRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putObjectAclRequest.contentMD5()));
        }
        if (putObjectAclRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString(putObjectAclRequest.grantFullControl()));
        }
        if (putObjectAclRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString(putObjectAclRequest.grantRead()));
        }
        if (putObjectAclRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString(putObjectAclRequest.grantReadACP()));
        }
        if (putObjectAclRequest.grantWrite() != null) {
            request.addHeader("x-amz-grant-write", StringUtils.fromString(putObjectAclRequest.grantWrite()));
        }
        if (putObjectAclRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString(putObjectAclRequest.grantWriteACP()));
        }
        if (putObjectAclRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(putObjectAclRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}?acl";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putObjectAclRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", putObjectAclRequest.key());
        request.setResourcePath(uriResourcePath);
        if (putObjectAclRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString(putObjectAclRequest.versionId()));
        }
        try {
            StringWriter stringWriter = null;
            AccessControlPolicy accessControlPolicy = putObjectAclRequest.accessControlPolicy();
            if (accessControlPolicy != null) {
                Owner owner;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("AccessControlPolicy");
                List<Grant> accessControlPolicyGrantsList = accessControlPolicy.grants();
                if (accessControlPolicyGrantsList != null) {
                    xmlWriter.startElement("AccessControlList");
                    for (Grant accessControlPolicyGrantsListValue : accessControlPolicyGrantsList) {
                        xmlWriter.startElement("Grant");
                        Grantee grantee = accessControlPolicyGrantsListValue.grantee();
                        if (grantee != null) {
                            xmlWriter.startElement("Grantee");
                            if (grantee.displayName() != null) {
                                xmlWriter.startElement("DisplayName").value(grantee.displayName()).endElement();
                            }
                            if (grantee.emailAddress() != null) {
                                xmlWriter.startElement("EmailAddress").value(grantee.emailAddress()).endElement();
                            }
                            if (grantee.id() != null) {
                                xmlWriter.startElement("ID").value(grantee.id()).endElement();
                            }
                            if (grantee.type() != null) {
                                xmlWriter.startElement("xsi:type").value(grantee.type()).endElement();
                            }
                            if (grantee.uri() != null) {
                                xmlWriter.startElement("URI").value(grantee.uri()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (accessControlPolicyGrantsListValue.permission() != null) {
                            xmlWriter.startElement("Permission").value(accessControlPolicyGrantsListValue.permission()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((owner = accessControlPolicy.owner()) != null) {
                    xmlWriter.startElement("Owner");
                    if (owner.displayName() != null) {
                        xmlWriter.startElement("DisplayName").value(owner.displayName()).endElement();
                    }
                    if (owner.id() != null) {
                        xmlWriter.startElement("ID").value(owner.id()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

