/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.util.StringUtils;

public class PutObjectRequestMarshaller
implements Marshaller<Request<PutObjectRequest>, PutObjectRequest> {
    @Override
    public Request<PutObjectRequest> marshall(PutObjectRequest putObjectRequest) {
        if (putObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutObjectRequest> request = new DefaultRequest<PutObjectRequest>(putObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putObjectRequest.acl() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString(putObjectRequest.acl()));
        }
        if (putObjectRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringUtils.fromString(putObjectRequest.cacheControl()));
        }
        if (putObjectRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringUtils.fromString(putObjectRequest.contentDisposition()));
        }
        if (putObjectRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringUtils.fromString(putObjectRequest.contentEncoding()));
        }
        if (putObjectRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringUtils.fromString(putObjectRequest.contentLanguage()));
        }
        if (putObjectRequest.contentLength() != null) {
            request.addHeader("Content-Length", StringUtils.fromLong(putObjectRequest.contentLength()));
        }
        if (putObjectRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putObjectRequest.contentMD5()));
        }
        if (putObjectRequest.contentType() != null) {
            request.addHeader("Content-Type", StringUtils.fromString(putObjectRequest.contentType()));
        }
        if (putObjectRequest.expires() != null) {
            request.addHeader("Expires", StringUtils.fromDate(putObjectRequest.expires()));
        }
        if (putObjectRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString(putObjectRequest.grantFullControl()));
        }
        if (putObjectRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString(putObjectRequest.grantRead()));
        }
        if (putObjectRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString(putObjectRequest.grantReadACP()));
        }
        if (putObjectRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString(putObjectRequest.grantWriteACP()));
        }
        if (putObjectRequest.serverSideEncryption() != null) {
            request.addHeader("x-amz-server-side-encryption", StringUtils.fromString(putObjectRequest.serverSideEncryption()));
        }
        if (putObjectRequest.storageClass() != null) {
            request.addHeader("x-amz-storage-class", StringUtils.fromString(putObjectRequest.storageClass()));
        }
        if (putObjectRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", StringUtils.fromString(putObjectRequest.websiteRedirectLocation()));
        }
        if (putObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringUtils.fromString(putObjectRequest.sseCustomerAlgorithm()));
        }
        if (putObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringUtils.fromString(putObjectRequest.sseCustomerKey()));
        }
        if (putObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringUtils.fromString(putObjectRequest.sseCustomerKeyMD5()));
        }
        if (putObjectRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id", StringUtils.fromString(putObjectRequest.ssekmsKeyId()));
        }
        if (putObjectRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(putObjectRequest.requestPayer()));
        }
        if (putObjectRequest.tagging() != null) {
            request.addHeader("x-amz-tagging", StringUtils.fromString(putObjectRequest.tagging()));
        }
        if (putObjectRequest.metadata() != null) {
            putObjectRequest.metadata().entrySet().forEach(e -> {
                if (((String)e.getKey()).startsWith("x-amz-meta-")) {
                    request.addHeader((String)e.getKey(), (String)e.getValue());
                } else {
                    request.addHeader("x-amz-meta-" + (String)e.getKey(), (String)e.getValue());
                }
            });
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putObjectRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", putObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

