/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

public class PutObjectResponseUnmarshaller
implements Unmarshaller<PutObjectResponse, StaxUnmarshallerContext> {
    private static PutObjectResponseUnmarshaller INSTANCE;

    @Override
    public PutObjectResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        PutObjectResponse.Builder putObjectResponse = PutObjectResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-expiration");
            putObjectResponse.expiration(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("ETag");
            putObjectResponse.eTag(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption");
            putObjectResponse.serverSideEncryption(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-version-id");
            putObjectResponse.versionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-customer-algorithm");
            putObjectResponse.sseCustomerAlgorithm(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-customer-key-MD5");
            putObjectResponse.sseCustomerKeyMD5(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-server-side-encryption-aws-kms-key-id");
            putObjectResponse.ssekmsKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            context.setCurrentHeader("x-amz-request-charged");
            putObjectResponse.requestCharged(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
        }
        return (PutObjectResponse)putObjectResponse.build();
    }

    public static PutObjectResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PutObjectResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

