/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.QueueConfigurationDeprecated;

public class QueueConfigurationDeprecatedUnmarshaller
implements Unmarshaller<QueueConfigurationDeprecated, StaxUnmarshallerContext> {
    private static QueueConfigurationDeprecatedUnmarshaller INSTANCE;

    @Override
    public QueueConfigurationDeprecated unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        QueueConfigurationDeprecated.Builder queueConfigurationDeprecated = QueueConfigurationDeprecated.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    queueConfigurationDeprecated.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Event", targetDepth)) {
                    queueConfigurationDeprecated.event(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Event", targetDepth)) {
                    queueConfigurationDeprecated.events(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Queue", targetDepth)) continue;
                queueConfigurationDeprecated.queue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (QueueConfigurationDeprecated)queueConfigurationDeprecated.build();
    }

    public static QueueConfigurationDeprecatedUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new QueueConfigurationDeprecatedUnmarshaller();
        }
        return INSTANCE;
    }
}

