/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo;

public class RedirectAllRequestsToUnmarshaller
implements Unmarshaller<RedirectAllRequestsTo, StaxUnmarshallerContext> {
    private static RedirectAllRequestsToUnmarshaller INSTANCE;

    @Override
    public RedirectAllRequestsTo unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        RedirectAllRequestsTo.Builder redirectAllRequestsTo = RedirectAllRequestsTo.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HostName", targetDepth)) {
                    redirectAllRequestsTo.hostName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Protocol", targetDepth)) continue;
                redirectAllRequestsTo.protocol(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (RedirectAllRequestsTo)redirectAllRequestsTo.build();
    }

    public static RedirectAllRequestsToUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RedirectAllRequestsToUnmarshaller();
        }
        return INSTANCE;
    }
}

