/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.StringWriter;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.GlacierJobParameters;
import software.amazon.awssdk.services.s3.model.RestoreObjectRequest;
import software.amazon.awssdk.services.s3.model.RestoreRequest;
import software.amazon.awssdk.util.Md5Utils;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class RestoreObjectRequestMarshaller
implements Marshaller<Request<RestoreObjectRequest>, RestoreObjectRequest> {
    @Override
    public Request<RestoreObjectRequest> marshall(RestoreObjectRequest restoreObjectRequest) {
        if (restoreObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RestoreObjectRequest> request = new DefaultRequest<RestoreObjectRequest>(restoreObjectRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreObjectRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(restoreObjectRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}?restore";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest(request, uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", restoreObjectRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", restoreObjectRequest.key());
        request.setResourcePath(uriResourcePath);
        if (restoreObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString(restoreObjectRequest.versionId()));
        }
        try {
            StringWriter stringWriter = null;
            RestoreRequest restoreRequest = restoreObjectRequest.restoreRequest();
            if (restoreRequest != null) {
                GlacierJobParameters glacierJobParameters;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("RestoreRequest");
                if (restoreRequest.days() != null) {
                    xmlWriter.startElement("Days").value(restoreRequest.days()).endElement();
                }
                if ((glacierJobParameters = restoreRequest.glacierJobParameters()) != null) {
                    xmlWriter.startElement("GlacierJobParameters");
                    if (glacierJobParameters.tier() != null) {
                        xmlWriter.startElement("Tier").value(glacierJobParameters.tier()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

