/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.RoutingRule;
import software.amazon.awssdk.services.s3.transform.ConditionUnmarshaller;
import software.amazon.awssdk.services.s3.transform.RedirectUnmarshaller;

public class RoutingRuleUnmarshaller
implements Unmarshaller<RoutingRule, StaxUnmarshallerContext> {
    private static RoutingRuleUnmarshaller INSTANCE;

    @Override
    public RoutingRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        RoutingRule.Builder routingRule = RoutingRule.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Condition", targetDepth)) {
                    routingRule.condition(ConditionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Redirect", targetDepth)) continue;
                routingRule.redirect(RedirectUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (RoutingRule)routingRule.build();
    }

    public static RoutingRuleUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RoutingRuleUnmarshaller();
        }
        return INSTANCE;
    }
}

