/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.S3KeyFilter;
import software.amazon.awssdk.services.s3.transform.FilterRuleUnmarshaller;

public class S3KeyFilterUnmarshaller
implements Unmarshaller<S3KeyFilter, StaxUnmarshallerContext> {
    private static S3KeyFilterUnmarshaller INSTANCE;

    @Override
    public S3KeyFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        S3KeyFilter.Builder s3KeyFilter = S3KeyFilter.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("FilterRule", targetDepth)) continue;
                s3KeyFilter.filterRules(FilterRuleUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (S3KeyFilter)s3KeyFilter.build();
    }

    public static S3KeyFilterUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new S3KeyFilterUnmarshaller();
        }
        return INSTANCE;
    }
}

