/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.StorageClassAnalysis;
import software.amazon.awssdk.services.s3.transform.StorageClassAnalysisDataExportUnmarshaller;

public class StorageClassAnalysisUnmarshaller
implements Unmarshaller<StorageClassAnalysis, StaxUnmarshallerContext> {
    private static StorageClassAnalysisUnmarshaller INSTANCE;

    @Override
    public StorageClassAnalysis unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StorageClassAnalysis.Builder storageClassAnalysis = StorageClassAnalysis.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("DataExport", targetDepth)) continue;
                storageClassAnalysis.dataExport(StorageClassAnalysisDataExportUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StorageClassAnalysis)storageClassAnalysis.build();
    }

    public static StorageClassAnalysisUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StorageClassAnalysisUnmarshaller();
        }
        return INSTANCE;
    }
}

