/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.TopicConfiguration;
import software.amazon.awssdk.services.s3.transform.NotificationConfigurationFilterUnmarshaller;

public class TopicConfigurationUnmarshaller
implements Unmarshaller<TopicConfiguration, StaxUnmarshallerContext> {
    private static TopicConfigurationUnmarshaller INSTANCE;

    @Override
    public TopicConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        TopicConfiguration.Builder topicConfiguration = TopicConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    topicConfiguration.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Topic", targetDepth)) {
                    topicConfiguration.topicArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Event", targetDepth)) {
                    topicConfiguration.events(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Filter", targetDepth)) continue;
                topicConfiguration.filter(NotificationConfigurationFilterUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (TopicConfiguration)topicConfiguration.build();
    }

    public static TopicConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TopicConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

