/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.util.StringUtils;

public class UploadPartCopyRequestMarshaller
implements Marshaller<Request<UploadPartCopyRequest>, UploadPartCopyRequest> {
    @Override
    public Request<UploadPartCopyRequest> marshall(UploadPartCopyRequest uploadPartCopyRequest) {
        if (uploadPartCopyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UploadPartCopyRequest> request = new DefaultRequest<UploadPartCopyRequest>(uploadPartCopyRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (uploadPartCopyRequest.copySource() != null) {
            request.addHeader("x-amz-copy-source", StringUtils.fromString(uploadPartCopyRequest.copySource()));
        }
        if (uploadPartCopyRequest.copySourceIfMatch() != null) {
            request.addHeader("x-amz-copy-source-if-match", StringUtils.fromString(uploadPartCopyRequest.copySourceIfMatch()));
        }
        if (uploadPartCopyRequest.copySourceIfModifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-modified-since", StringUtils.fromDate(uploadPartCopyRequest.copySourceIfModifiedSince()));
        }
        if (uploadPartCopyRequest.copySourceIfNoneMatch() != null) {
            request.addHeader("x-amz-copy-source-if-none-match", StringUtils.fromString(uploadPartCopyRequest.copySourceIfNoneMatch()));
        }
        if (uploadPartCopyRequest.copySourceIfUnmodifiedSince() != null) {
            request.addHeader("x-amz-copy-source-if-unmodified-since", StringUtils.fromDate(uploadPartCopyRequest.copySourceIfUnmodifiedSince()));
        }
        if (uploadPartCopyRequest.copySourceRange() != null) {
            request.addHeader("x-amz-copy-source-range", StringUtils.fromString(uploadPartCopyRequest.copySourceRange()));
        }
        if (uploadPartCopyRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringUtils.fromString(uploadPartCopyRequest.sseCustomerAlgorithm()));
        }
        if (uploadPartCopyRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringUtils.fromString(uploadPartCopyRequest.sseCustomerKey()));
        }
        if (uploadPartCopyRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringUtils.fromString(uploadPartCopyRequest.sseCustomerKeyMD5()));
        }
        if (uploadPartCopyRequest.copySourceSSECustomerAlgorithm() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-algorithm", StringUtils.fromString(uploadPartCopyRequest.copySourceSSECustomerAlgorithm()));
        }
        if (uploadPartCopyRequest.copySourceSSECustomerKey() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key", StringUtils.fromString(uploadPartCopyRequest.copySourceSSECustomerKey()));
        }
        if (uploadPartCopyRequest.copySourceSSECustomerKeyMD5() != null) {
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", StringUtils.fromString(uploadPartCopyRequest.copySourceSSECustomerKeyMD5()));
        }
        if (uploadPartCopyRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(uploadPartCopyRequest.requestPayer()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", uploadPartCopyRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", uploadPartCopyRequest.key());
        request.setResourcePath(uriResourcePath);
        if (uploadPartCopyRequest.partNumber() != null) {
            request.addParameter("partNumber", StringUtils.fromInteger(uploadPartCopyRequest.partNumber()));
        }
        if (uploadPartCopyRequest.uploadId() != null) {
            request.addParameter("uploadId", StringUtils.fromString(uploadPartCopyRequest.uploadId()));
        }
        return request;
    }
}

