/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.test;

import java.io.InputStream;
import org.junit.BeforeClass;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.utils.IoUtils;

public abstract class AwsIntegrationTestBase {
    private static final String TEST_CREDENTIALS_PROFILE_NAME = "aws-test-account";
    public static final AwsCredentialsProviderChain CREDENTIALS_PROVIDER_CHAIN = AwsCredentialsProviderChain.builder().credentialsProviders(ProfileCredentialsProvider.builder().profileName("aws-test-account").build(), new SystemPropertyCredentialsProvider(), new EnvironmentVariableCredentialsProvider()).build();
    private static AwsCredentials credentials;

    @BeforeClass
    public static void setUpCredentials() {
        if (credentials == null) {
            try {
                credentials = CREDENTIALS_PROVIDER_CHAIN.getCredentials();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static AwsCredentials getCredentials() {
        return credentials;
    }

    protected String getResourceAsString(String location) {
        try {
            InputStream resourceStream = this.getClass().getResourceAsStream(location);
            String resourceAsString = IoUtils.toString(resourceStream);
            resourceStream.close();
            return resourceAsString;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

