/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.test.retry;

import java.util.concurrent.TimeUnit;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import software.amazon.awssdk.util.ValidationUtils;
import software.amazon.awssdk.utils.Logger;

public class RetryRule
implements TestRule {
    private static final Logger log = Logger.loggerFor(RetryRule.class);
    private int maxRetryAttempts;
    private long delay;
    private TimeUnit timeUnit;

    public RetryRule(int maxRetryAttempts) {
        this(maxRetryAttempts, 0L, TimeUnit.SECONDS);
    }

    public RetryRule(int maxRetryAttempts, long delay, TimeUnit timeUnit) {
        this.maxRetryAttempts = maxRetryAttempts;
        this.delay = delay;
        this.timeUnit = ValidationUtils.assertNotNull(timeUnit, "timeUnit");
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                this.retry(base, 1);
            }

            public void retry(Statement base2, int attempts) throws Throwable {
                try {
                    base2.evaluate();
                }
                catch (Exception e) {
                    if (attempts > RetryRule.this.maxRetryAttempts) {
                        throw e;
                    }
                    log.warn(() -> "Test failed. Retrying with delay of: " + RetryRule.this.delay + " " + (Object)((Object)RetryRule.this.timeUnit));
                    RetryRule.this.timeUnit.sleep(RetryRule.this.delay);
                    this.retry(base2, ++attempts);
                }
            }
        };
    }
}

