/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.test.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;
import software.amazon.awssdk.runtime.io.SdkInputStream;

public class ConstantInputStream
extends SdkInputStream {
    private static final Random RAND = new Random();
    private final byte val;
    private final boolean randomlyReturnZeros;
    private long remaining;
    private int randomZerosCount;

    public ConstantInputStream(long total, byte val2) {
        this.remaining = total;
        this.val = val2;
        this.randomlyReturnZeros = false;
    }

    public ConstantInputStream(long total, byte val2, boolean randomlyReturnZeros) {
        this.remaining = total;
        this.val = val2;
        this.randomlyReturnZeros = randomlyReturnZeros;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.randomlyReturnZeros && RAND.nextBoolean()) {
            ++this.randomZerosCount;
            return 0;
        }
        if (this.remaining <= 0L) {
            return -1;
        }
        if ((long)len > this.remaining) {
            len = (int)this.remaining;
        }
        this.remaining -= (long)len;
        Arrays.fill(b, off, off + len, this.val);
        return len;
    }

    @Override
    public int read() throws IOException {
        if (this.randomlyReturnZeros && RAND.nextBoolean()) {
            ++this.randomZerosCount;
            return 0;
        }
        if (this.remaining <= 0L) {
            return -1;
        }
        --this.remaining;
        return this.val;
    }

    public int getRandomZerosCount() {
        return this.randomZerosCount;
    }

    @Override
    protected InputStream getWrappedInputStream() {
        return null;
    }
}

