/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.test.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;

public enum Memory {


    public static String heapSummary() {
        Runtime rt = Runtime.getRuntime();
        long totalMem = rt.totalMemory();
        long freeMem = rt.freeMemory();
        long usedMem = totalMem - freeMem;
        long spareMem = rt.maxMemory() - usedMem;
        return String.format("Heap usedMem=%d (KB), freeMem=%d (KB), spareMem=%d (KB)\n", usedMem / 1024L, freeMem / 1024L, spareMem / 1024L);
    }

    public static String poolSummaries() {
        StringBuilder sb = new StringBuilder();
        for (MemoryPoolMXBean item : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = item.getName();
            MemoryType type = item.getType();
            MemoryUsage usage = item.getUsage();
            MemoryUsage peak = item.getPeakUsage();
            MemoryUsage collections = item.getCollectionUsage();
            sb.append(String.format("Memory pool name: " + name + ", type: " + (Object)((Object)type) + ", usage: " + usage + ", peak: " + peak + ", collections: " + collections + "\n", new Object[0]));
        }
        return sb.toString();
    }
}

