/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.test.util;

import com.google.common.util.concurrent.ForwardingExecutorService;
import com.google.common.util.concurrent.Futures;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class TestExecutors {
    private TestExecutors() {
    }

    public static ExecutorService blocksOnFirstCallFromCallableOfType(final ExecutorService delegate, final Class<? extends Callable> type) {
        return new ForwardingExecutorService(){
            private boolean firstCall = true;

            @Override
            protected ExecutorService delegate() {
                return delegate;
            }

            @Override
            public <T> Future<T> submit(Callable<T> task) {
                if (task.getClass().equals(type) && this.firstCall) {
                    this.firstCall = false;
                    try {
                        return Futures.immediateFuture(task.call());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return super.submit(task);
            }
        };
    }
}

