/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.test.util;

import java.io.IOException;
import software.amazon.awssdk.test.util.RandomInputStream;
import software.amazon.awssdk.utils.Logger;

public class UnreliableRandomInputStream
extends RandomInputStream {
    private static final Logger log = Logger.loggerFor(UnreliableRandomInputStream.class);
    private static final boolean DEBUG = false;
    private boolean hasTriggeredAnException = false;

    public UnreliableRandomInputStream(long lengthInBytes) {
        super(lengthInBytes);
    }

    @Override
    public int read() throws IOException {
        this.triggerException();
        return super.read();
    }

    private void triggerException() throws IOException {
        if (this.remainingBytes <= this.lengthInBytes / 2L && !this.hasTriggeredAnException) {
            this.hasTriggeredAnException = true;
            String msg = "UnreliableBogusInputStream fired an IOException after reading " + this.getBytesRead() + " bytes.";
            throw new IOException(msg);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.triggerException();
        int read = super.read(b, off, len);
        return read;
    }

    private static /* synthetic */ String lambda$read$1(int read, int off, int len, byte[] b) {
        return "read=" + read + ", off=" + off + ", len=" + len + ", b.length=" + b.length;
    }

    private static /* synthetic */ String lambda$triggerException$0(String msg) {
        return msg;
    }
}

