/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.util;

import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.internal.Crc32MismatchException;
import software.amazon.awssdk.runtime.io.SdkFilterInputStream;
import software.amazon.awssdk.util.Crc32ChecksumCalculatingInputStream;

public class Crc32ChecksumValidatingInputStream
extends SdkFilterInputStream {
    private final long expectedChecksum;

    public Crc32ChecksumValidatingInputStream(InputStream in, long expectedChecksum) {
        super(new Crc32ChecksumCalculatingInputStream(in));
        this.expectedChecksum = expectedChecksum;
    }

    @Override
    public void close() throws IOException {
        try {
            this.validateChecksum();
        }
        finally {
            super.close();
        }
    }

    private void validateChecksum() throws Crc32MismatchException {
        long actualChecksum = ((Crc32ChecksumCalculatingInputStream)this.in).getCrc32Checksum();
        if (this.expectedChecksum != actualChecksum) {
            throw new Crc32MismatchException(String.format("Expected %d as the Crc32 checksum but the actual calculatedchecksum was %d", this.expectedChecksum, actualChecksum));
        }
    }
}

