/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.tz.FixedDateTimeZone;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.util.JodaTime;

@ThreadSafe
public class DateUtils {
    private static final DateTimeZone GMT = new FixedDateTimeZone("GMT", "GMT", 0, 0);
    protected static final DateTimeFormatter ISO_8601_DATE_FORMAT = ISODateTimeFormat.dateTime().withZone(GMT);
    protected static final DateTimeFormatter ALTERNATE_ISO_8601_DATE_FORMAT = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(GMT);
    protected static final DateTimeFormatter RFC_822_DATE_FORMAT = DateTimeFormat.forPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(GMT);
    protected static final DateTimeFormatter COMPRESSED_ISO_8601_DATE_FORMAT = DateTimeFormat.forPattern("yyyyMMdd'T'HHmmss'Z'").withZone(GMT);
    private static final long MILLI_SECONDS_OF_365_DAYS = 31536000000L;
    private static final int AWS_DATE_MILLI_SECOND_PRECISION = 3;

    public static Date parseIso8601Date(String dateString) {
        try {
            return DateUtils.doParseIso8601Date(dateString);
        }
        catch (RuntimeException ex) {
            throw DateUtils.handleException(ex);
        }
    }

    static Date doParseIso8601Date(String dateStringOrig) {
        String dateString = dateStringOrig;
        if (dateString.endsWith("+0000")) {
            dateString = dateString.substring(0, dateString.length() - 5).concat("Z");
        }
        String temp = DateUtils.tempDateStringForJodaTime(dateString);
        try {
            if (temp.equals(dateString)) {
                return new Date(ISO_8601_DATE_FORMAT.parseMillis(dateString));
            }
            long milliLess365Days = ISO_8601_DATE_FORMAT.parseMillis(temp);
            long milli = milliLess365Days + 31536000000L;
            if (milli < 0L) {
                return new Date(ISO_8601_DATE_FORMAT.parseMillis(dateString));
            }
            return new Date(milli);
        }
        catch (IllegalArgumentException e) {
            try {
                return new Date(ALTERNATE_ISO_8601_DATE_FORMAT.parseMillis(dateString));
            }
            catch (Exception oops) {
                throw e;
            }
        }
    }

    private static String tempDateStringForJodaTime(String dateString) {
        String fromPrefix = "292278994-";
        String toPrefix = "292278993-";
        return dateString.startsWith("292278994-") ? "292278993-" + dateString.substring("292278994-".length()) : dateString;
    }

    private static <E extends RuntimeException> E handleException(E ex) {
        if (JodaTime.hasExpectedBehavior()) {
            return ex;
        }
        throw new IllegalStateException("Joda-time 2.2 or later version is required, but found version: " + JodaTime.getVersion(), ex);
    }

    public static String formatIso8601Date(Date date) {
        try {
            return ISO_8601_DATE_FORMAT.print(date.getTime());
        }
        catch (RuntimeException ex) {
            throw DateUtils.handleException(ex);
        }
    }

    public static String formatIso8601Date(DateTime date) {
        try {
            return ISO_8601_DATE_FORMAT.print(date);
        }
        catch (RuntimeException ex) {
            throw DateUtils.handleException(ex);
        }
    }

    public static Date parseRfc822Date(String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            return new Date(RFC_822_DATE_FORMAT.parseMillis(dateString));
        }
        catch (RuntimeException ex) {
            throw DateUtils.handleException(ex);
        }
    }

    public static String formatRfc822Date(Date date) {
        try {
            return RFC_822_DATE_FORMAT.print(date.getTime());
        }
        catch (RuntimeException ex) {
            throw DateUtils.handleException(ex);
        }
    }

    public static Date parseCompressedIso8601Date(String dateString) {
        try {
            return new Date(COMPRESSED_ISO_8601_DATE_FORMAT.parseMillis(dateString));
        }
        catch (RuntimeException ex) {
            throw DateUtils.handleException(ex);
        }
    }

    public static Date parseServiceSpecificDate(String dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            BigDecimal dateValue = new BigDecimal(dateString);
            return new Date(dateValue.scaleByPowerOfTen(3).longValue());
        }
        catch (NumberFormatException nfe) {
            throw new SdkClientException("Unable to parse date : " + dateString, nfe);
        }
    }

    public static String formatServiceSpecificDate(Date date) {
        if (date == null) {
            return null;
        }
        BigDecimal dateValue = BigDecimal.valueOf(date.getTime());
        return dateValue.scaleByPowerOfTen(-3).toPlainString();
    }

    public static Date cloneDate(Date date) {
        return date == null ? null : new Date(date.getTime());
    }

    public static long numberOfDaysSinceEpoch(long milliSinceEpoch) {
        return TimeUnit.MILLISECONDS.toDays(milliSinceEpoch);
    }
}

