/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.util;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Stack;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.utils.Base64Utils;
import software.amazon.awssdk.utils.BinaryUtils;

public class XmlWriter {
    private static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private final Writer writer;
    private final String xmlns;
    private Stack<String> elementStack = new Stack();
    private boolean rootElement = true;

    public XmlWriter(Writer w) {
        this(w, null);
    }

    public XmlWriter(Writer w, String xmlns) {
        this.writer = w;
        this.xmlns = xmlns;
        this.append(PROLOG);
    }

    public XmlWriter startElement(String element) {
        this.append("<" + element);
        if (this.rootElement && this.xmlns != null) {
            this.append(" xmlns=\"" + this.xmlns + "\"");
            this.rootElement = false;
        }
        this.append(">");
        this.elementStack.push(element);
        return this;
    }

    public XmlWriter endElement() {
        String lastElement = this.elementStack.pop();
        this.append("</" + lastElement + ">");
        return this;
    }

    public XmlWriter value(String s) {
        this.append(this.escapeXmlEntities(s));
        return this;
    }

    public XmlWriter value(ByteBuffer b) {
        this.append(this.escapeXmlEntities(Base64Utils.encodeAsString(BinaryUtils.copyBytesFrom(b))));
        return this;
    }

    public XmlWriter value(Date date) {
        this.append(this.escapeXmlEntities(StringUtils.fromDate(date)));
        return this;
    }

    public XmlWriter value(Object obj) {
        this.append(this.escapeXmlEntities(obj.toString()));
        return this;
    }

    private void append(String s) {
        try {
            this.writer.append(s);
        }
        catch (IOException e) {
            throw new SdkClientException("Unable to write XML document", e);
        }
    }

    private String escapeXmlEntities(String s) {
        if (s.contains("&")) {
            s = s.replace("&quot;", "\"");
            s = s.replace("&apos;", "'");
            s = s.replace("&lt;", "<");
            s = s.replace("&gt;", ">");
            s = s.replace("&amp;", "&");
        }
        s = s.replace("&", "&amp;");
        s = s.replace("\"", "&quot;");
        s = s.replace("'", "&apos;");
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        return s;
    }
}

