/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.waiters;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkProtectedApi
public class HttpFailureStatusAcceptor<OutputT>
extends WaiterAcceptor<OutputT> {
    private final int expectedStatusCode;
    private final WaiterState waiterState;

    public HttpFailureStatusAcceptor(int expectedStatusCode, WaiterState waiterState) {
        this.expectedStatusCode = expectedStatusCode;
        this.waiterState = waiterState;
    }

    @Override
    public boolean matches(AmazonServiceException ase) {
        return this.expectedStatusCode == ase.getStatusCode();
    }

    @Override
    public WaiterState getState() {
        return this.waiterState;
    }
}

