/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.QueryValidationException;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.TableOptions;
import com.google.common.collect.Lists;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.Lazy;
import io.vavr.Predicates;
import io.vavr.Tuple;
import io.vavr.Tuple3;
import io.vavr.collection.Array;
import io.vavr.collection.Iterator;
import io.vavr.control.Try;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLColValGetter;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.CQLResultSetKeyIterator;
import org.janusgraph.diskstorage.cql.CQLStoreManager;
import org.janusgraph.diskstorage.cql.CQLTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.StaticArrayEntryList;

public class CQLKeyColumnValueStore
implements KeyColumnValueStore {
    private static final String TTL_FUNCTION_NAME = "ttl";
    private static final String WRITETIME_FUNCTION_NAME = "writetime";
    static final String KEY_COLUMN_NAME = "key";
    static final String COLUMN_COLUMN_NAME = "column1";
    static final String VALUE_COLUMN_NAME = "value";
    static final String WRITETIME_COLUMN_NAME = "writetime";
    static final String TTL_COLUMN_NAME = "ttl";
    private static final String KEY_BINDING = "key";
    private static final String COLUMN_BINDING = "column1";
    private static final String VALUE_BINDING = "value";
    private static final String TIMESTAMP_BINDING = "timestamp";
    private static final String TTL_BINDING = "ttl";
    private static final String SLICE_START_BINDING = "sliceStart";
    private static final String SLICE_END_BINDING = "sliceEnd";
    private static final String KEY_START_BINDING = "keyStart";
    private static final String KEY_END_BINDING = "keyEnd";
    private static final String LIMIT_BINDING = "maxRows";
    static final Function<? super Throwable, BackendException> EXCEPTION_MAPPER = cause -> (BackendException)API.Match((Object)cause).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(QueryValidationException.class)), qve -> new PermanentBackendException((Throwable)qve)), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(UnsupportedFeatureException.class)), ufe -> new PermanentBackendException((Throwable)ufe)), API.Case((API.Match.Pattern0)API.$(), t -> new TemporaryBackendException(t))});
    private final CQLStoreManager storeManager;
    private final ExecutorService executorService;
    private final Session session;
    private final String tableName;
    private final CQLColValGetter getter;
    private final Runnable closer;
    private final PreparedStatement getSlice;
    private final PreparedStatement getKeysAll;
    private final PreparedStatement getKeysRanged;
    private final PreparedStatement deleteColumn;
    private final PreparedStatement insertColumn;
    private final PreparedStatement insertColumnWithTTL;

    public CQLKeyColumnValueStore(CQLStoreManager storeManager, String tableName, Configuration configuration, Runnable closer, boolean allowCompactStorage, Supplier<Boolean> shouldInitializeTable) {
        this.storeManager = storeManager;
        this.executorService = this.storeManager.getExecutorService();
        this.tableName = tableName;
        this.closer = closer;
        this.session = this.storeManager.getSession();
        this.getter = new CQLColValGetter(storeManager.getMetaDataSchema(this.tableName));
        if (shouldInitializeTable.get().booleanValue()) {
            CQLKeyColumnValueStore.initializeTable(this.session, this.storeManager.getKeyspaceName(), tableName, configuration, allowCompactStorage);
        }
        this.getSlice = this.session.prepare((RegularStatement)QueryBuilder.select().column("column1").column("value").fcall("writetime", new Object[]{QueryBuilder.column((String)"value")}).as("writetime").fcall("ttl", new Object[]{QueryBuilder.column((String)"value")}).as("ttl").from(this.storeManager.getKeyspaceName(), this.tableName).where(QueryBuilder.eq((String)"key", (Object)QueryBuilder.bindMarker((String)"key"))).and(QueryBuilder.gte((String)"column1", (Object)QueryBuilder.bindMarker((String)SLICE_START_BINDING))).and(QueryBuilder.lt((String)"column1", (Object)QueryBuilder.bindMarker((String)SLICE_END_BINDING))).limit(QueryBuilder.bindMarker((String)LIMIT_BINDING)));
        this.getKeysRanged = this.session.prepare((RegularStatement)QueryBuilder.select().column("key").column("column1").column("value").fcall("writetime", new Object[]{QueryBuilder.column((String)"value")}).as("writetime").fcall("ttl", new Object[]{QueryBuilder.column((String)"value")}).as("ttl").from(this.storeManager.getKeyspaceName(), this.tableName).allowFiltering().where(QueryBuilder.gte((String)QueryBuilder.token((String)"key"), (Object)QueryBuilder.bindMarker((String)KEY_START_BINDING))).and(QueryBuilder.lt((String)QueryBuilder.token((String)"key"), (Object)QueryBuilder.bindMarker((String)KEY_END_BINDING))).and(QueryBuilder.gte((String)"column1", (Object)QueryBuilder.bindMarker((String)SLICE_START_BINDING))).and(QueryBuilder.lte((String)"column1", (Object)QueryBuilder.bindMarker((String)SLICE_END_BINDING))));
        this.getKeysAll = this.session.prepare((RegularStatement)QueryBuilder.select().column("key").column("column1").column("value").fcall("writetime", new Object[]{QueryBuilder.column((String)"value")}).as("writetime").fcall("ttl", new Object[]{QueryBuilder.column((String)"value")}).as("ttl").from(this.storeManager.getKeyspaceName(), this.tableName).allowFiltering().where(QueryBuilder.gte((String)"column1", (Object)QueryBuilder.bindMarker((String)SLICE_START_BINDING))).and(QueryBuilder.lte((String)"column1", (Object)QueryBuilder.bindMarker((String)SLICE_END_BINDING))));
        this.deleteColumn = this.session.prepare((RegularStatement)QueryBuilder.delete().from(this.storeManager.getKeyspaceName(), this.tableName).where(QueryBuilder.eq((String)"key", (Object)QueryBuilder.bindMarker((String)"key"))).and(QueryBuilder.eq((String)"column1", (Object)QueryBuilder.bindMarker((String)"column1"))).using(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker((String)TIMESTAMP_BINDING))));
        this.insertColumn = this.session.prepare((RegularStatement)QueryBuilder.insertInto((String)this.storeManager.getKeyspaceName(), (String)this.tableName).value("key", (Object)QueryBuilder.bindMarker((String)"key")).value("column1", (Object)QueryBuilder.bindMarker((String)"column1")).value("value", (Object)QueryBuilder.bindMarker((String)"value")).using(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker((String)TIMESTAMP_BINDING))));
        this.insertColumnWithTTL = this.session.prepare((RegularStatement)QueryBuilder.insertInto((String)this.storeManager.getKeyspaceName(), (String)this.tableName).value("key", (Object)QueryBuilder.bindMarker((String)"key")).value("column1", (Object)QueryBuilder.bindMarker((String)"column1")).value("value", (Object)QueryBuilder.bindMarker((String)"value")).using(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker((String)TIMESTAMP_BINDING))).and(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl"))));
    }

    private static void initializeTable(Session session, String keyspaceName, String tableName, Configuration configuration, boolean allowCompactStorage) {
        Create.Options createTable = (Create.Options)((Create.Options)((Create)((Create)SchemaBuilder.createTable((String)keyspaceName, (String)tableName).ifNotExists()).addPartitionKey("key", DataType.blob()).addClusteringColumn("column1", DataType.blob()).addColumn("value", DataType.blob())).withOptions().compressionOptions(CQLKeyColumnValueStore.compressionOptions(configuration))).compactionOptions(CQLKeyColumnValueStore.compactionOptions(configuration));
        boolean useCompactStorage = allowCompactStorage && configuration.has(CQLConfigOptions.CF_COMPACT_STORAGE, new String[0]) ? (Boolean)configuration.get(CQLConfigOptions.CF_COMPACT_STORAGE, new String[0]) : allowCompactStorage;
        session.execute((Statement)(useCompactStorage ? createTable.compactStorage() : createTable));
    }

    private static TableOptions.CompressionOptions compressionOptions(Configuration configuration) {
        if (!((Boolean)configuration.get(CQLConfigOptions.CF_COMPRESSION, new String[0])).booleanValue()) {
            return SchemaBuilder.noCompression();
        }
        return ((TableOptions.CompressionOptions)API.Match((Object)configuration.get(CQLConfigOptions.CF_COMPRESSION_TYPE, new String[0])).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Object)"LZ4Compressor"), (Object)SchemaBuilder.lz4()), API.Case((API.Match.Pattern0)API.$((Object)"SnappyCompressor"), (Object)SchemaBuilder.snappy()), API.Case((API.Match.Pattern0)API.$((Object)"DeflateCompressor"), (Object)SchemaBuilder.deflate())})).withChunkLengthInKb((Integer)configuration.get(CQLConfigOptions.CF_COMPRESSION_BLOCK_SIZE, new String[0]));
    }

    private static TableOptions.CompactionOptions<?> compactionOptions(Configuration configuration) {
        if (!configuration.has(CQLConfigOptions.COMPACTION_STRATEGY, new String[0])) {
            return null;
        }
        TableOptions.CompactionOptions compactionOptions = (TableOptions.CompactionOptions)API.Match((Object)configuration.get(CQLConfigOptions.COMPACTION_STRATEGY, new String[0])).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Object)"SizeTieredCompactionStrategy"), (Object)SchemaBuilder.sizedTieredStategy()), API.Case((API.Match.Pattern0)API.$((Object)"DateTieredCompactionStrategy"), (Object)SchemaBuilder.dateTieredStrategy()), API.Case((API.Match.Pattern0)API.$((Object)"LeveledCompactionStrategy"), (Object)SchemaBuilder.leveledStrategy())});
        Array.of((Object[])((Object[])configuration.get(CQLConfigOptions.COMPACTION_OPTIONS, new String[0]))).grouped(2).forEach(keyValue -> compactionOptions.freeformOption((String)keyValue.get(0), keyValue.get(1)));
        return compactionOptions;
    }

    public void close() throws BackendException {
        this.closer.run();
    }

    public String getName() {
        return this.tableName;
    }

    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        io.vavr.concurrent.Future result = io.vavr.concurrent.Future.fromJavaFuture((ExecutorService)this.executorService, (Future)this.session.executeAsync(this.getSlice.bind().setBytes("key", query.getKey().asByteBuffer()).setBytes(SLICE_START_BINDING, query.getSliceStart().asByteBuffer()).setBytes(SLICE_END_BINDING, query.getSliceEnd().asByteBuffer()).setInt(LIMIT_BINDING, query.getLimit()).setConsistencyLevel(CQLTransaction.getTransaction(txh).getReadConsistencyLevel()))).map(resultSet -> CQLKeyColumnValueStore.fromResultSet(resultSet, this.getter));
        this.awaitInterruptibly(result);
        return (EntryList)((Try)result.getValue().get()).getOrElseThrow(EXCEPTION_MAPPER);
    }

    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException("The CQL backend does not support multi-key queries");
    }

    private void awaitInterruptibly(io.vavr.concurrent.Future<?> result) throws PermanentBackendException {
        try {
            result.await();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private static EntryList fromResultSet(ResultSet resultSet, StaticArrayEntry.GetColVal<Tuple3<StaticBuffer, StaticBuffer, Row>, StaticBuffer> getter) {
        Lazy lazyList = Lazy.of(() -> Lists.newArrayList((Iterable)resultSet));
        return StaticArrayEntryList.ofStaticBuffer(() -> Iterator.ofAll((Iterable)((Iterable)lazyList.get())).map(row -> Tuple.of((Object)StaticArrayBuffer.of((ByteBuffer)row.getBytes("column1")), (Object)StaticArrayBuffer.of((ByteBuffer)row.getBytes("value")), (Object)row)), getter);
    }

    Statement deleteColumn(StaticBuffer key, StaticBuffer column, long timestamp) {
        return this.deleteColumn.bind().setBytes("key", key.asByteBuffer()).setBytes("column1", column.asByteBuffer()).setLong(TIMESTAMP_BINDING, timestamp);
    }

    Statement insertColumn(StaticBuffer key, Entry entry, long timestamp) {
        Integer ttl = (Integer)entry.getMetaData().get(EntryMetaData.TTL);
        if (ttl != null) {
            return this.insertColumnWithTTL.bind().setBytes("key", key.asByteBuffer()).setBytes("column1", entry.getColumn().asByteBuffer()).setBytes("value", entry.getValue().asByteBuffer()).setLong(TIMESTAMP_BINDING, timestamp).setInt("ttl", ttl.intValue());
        }
        return this.insertColumn.bind().setBytes("key", key.asByteBuffer()).setBytes("column1", entry.getColumn().asByteBuffer()).setBytes("value", entry.getValue().asByteBuffer()).setLong(TIMESTAMP_BINDING, timestamp);
    }

    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        this.storeManager.mutateMany(Collections.singletonMap(this.tableName, Collections.singletonMap(key, new KCVMutation(additions, deletions))), txh);
    }

    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException();
    }

    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) throws BackendException {
        if (!this.storeManager.getFeatures().hasOrderedScan()) {
            throw new PermanentBackendException("This operation is only allowed when the byteorderedpartitioner is used.");
        }
        Metadata metadata = this.session.getCluster().getMetadata();
        return (KeyIterator)Try.of((CheckedFunction0 & Serializable)() -> new CQLResultSetKeyIterator((SliceQuery)query, this.getter, this.session.execute(this.getKeysRanged.bind().setToken(KEY_START_BINDING, metadata.newToken(new ByteBuffer[]{query.getKeyStart().asByteBuffer()})).setToken(KEY_END_BINDING, metadata.newToken(new ByteBuffer[]{query.getKeyEnd().asByteBuffer()})).setBytes(SLICE_START_BINDING, query.getSliceStart().asByteBuffer()).setBytes(SLICE_END_BINDING, query.getSliceEnd().asByteBuffer()).setFetchSize(this.storeManager.getPageSize()).setConsistencyLevel(CQLTransaction.getTransaction(txh).getReadConsistencyLevel())))).getOrElseThrow(EXCEPTION_MAPPER);
    }

    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) throws BackendException {
        if (this.storeManager.getFeatures().hasOrderedScan()) {
            throw new PermanentBackendException("This operation is only allowed when a random partitioner (md5 or murmur3) is used.");
        }
        return (KeyIterator)Try.of((CheckedFunction0 & Serializable)() -> new CQLResultSetKeyIterator(query, this.getter, this.session.execute(this.getKeysAll.bind().setBytes(SLICE_START_BINDING, query.getSliceStart().asByteBuffer()).setBytes(SLICE_END_BINDING, query.getSliceEnd().asByteBuffer()).setFetchSize(this.storeManager.getPageSize()).setConsistencyLevel(CQLTransaction.getTransaction(txh).getReadConsistencyLevel())))).getOrElseThrow(EXCEPTION_MAPPER);
    }
}

