/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.driver.core.ConsistencyLevel;
import com.google.common.base.Preconditions;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.common.AbstractStoreTransaction;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;

public class CQLTransaction
extends AbstractStoreTransaction {
    private final ConsistencyLevel readConsistencyLevel = ConsistencyLevel.valueOf((String)((String)this.getConfiguration().getCustomOption(CQLConfigOptions.READ_CONSISTENCY)));
    private final ConsistencyLevel writeConsistencyLevel = ConsistencyLevel.valueOf((String)((String)this.getConfiguration().getCustomOption(CQLConfigOptions.WRITE_CONSISTENCY)));

    public CQLTransaction(BaseTransactionConfig config) {
        super(config);
    }

    ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    static CQLTransaction getTransaction(StoreTransaction storeTransaction) {
        Preconditions.checkArgument((storeTransaction != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(storeTransaction instanceof CQLTransaction), (String)"Unexpected transaction type %s", (Object[])new Object[]{storeTransaction.getClass().getName()});
        return (CQLTransaction)storeTransaction;
    }

    public String toString() {
        return "CQLTransaction@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + "[read=" + this.readConsistencyLevel + ",write=" + this.writeConsistencyLevel + "]";
    }
}

