/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.builder;

import com.datastax.oss.driver.api.core.CqlSession;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ExecutorServiceBuilder;
import org.janusgraph.diskstorage.configuration.ExecutorServiceConfiguration;
import org.janusgraph.diskstorage.configuration.ExecutorServiceInstrumentation;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.builder.CQLMutateManyFunctionWrapper;
import org.janusgraph.diskstorage.cql.function.ConsumerWithBackendException;
import org.janusgraph.diskstorage.cql.function.mutate.AbstractCQLMutateManyFunction;
import org.janusgraph.diskstorage.cql.function.mutate.CQLExecutorServiceMutateManyLoggedFunction;
import org.janusgraph.diskstorage.cql.function.mutate.CQLExecutorServiceMutateManyUnloggedFunction;
import org.janusgraph.diskstorage.cql.function.mutate.CQLMutateManyFunction;
import org.janusgraph.diskstorage.cql.function.mutate.CQLSimpleMutateManyLoggedFunction;
import org.janusgraph.diskstorage.cql.function.mutate.CQLSimpleMutateManyUnloggedFunction;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class CQLMutateManyFunctionBuilder {
    public CQLMutateManyFunctionWrapper build(CqlSession session, Configuration configuration, TimestampProvider times, boolean assignTimestamp, Map<String, CQLKeyColumnValueStore> openStores, ConsumerWithBackendException<DistributedStoreManager.MaskedTimestamp> sleepAfterWriteFunction) {
        AbstractCQLMutateManyFunction mutateManyFunction;
        ExecutorService executorService;
        int batchSize = (Integer)configuration.get(CQLConfigOptions.BATCH_STATEMENT_SIZE, new String[0]);
        boolean atomicBatch = (Boolean)configuration.get(CQLConfigOptions.ATOMIC_BATCH_MUTATE, new String[0]);
        if (((Boolean)configuration.get(CQLConfigOptions.EXECUTOR_SERVICE_ENABLED, new String[0])).booleanValue()) {
            executorService = this.buildExecutorService(configuration);
            try {
                if (atomicBatch) {
                    mutateManyFunction = new CQLExecutorServiceMutateManyLoggedFunction(times, assignTimestamp, openStores, session, executorService, sleepAfterWriteFunction);
                }
                mutateManyFunction = new CQLExecutorServiceMutateManyUnloggedFunction(batchSize, session, openStores, times, executorService, assignTimestamp, sleepAfterWriteFunction);
            }
            catch (RuntimeException e) {
                executorService.shutdown();
                throw e;
            }
        } else {
            executorService = null;
            mutateManyFunction = atomicBatch ? new CQLSimpleMutateManyLoggedFunction(times, assignTimestamp, openStores, session, sleepAfterWriteFunction) : new CQLSimpleMutateManyUnloggedFunction(batchSize, session, openStores, times, assignTimestamp, sleepAfterWriteFunction);
        }
        return new CQLMutateManyFunctionWrapper(executorService, (CQLMutateManyFunction)((Object)mutateManyFunction));
    }

    private ExecutorService buildExecutorService(Configuration configuration) {
        Integer corePoolSize = (Integer)configuration.getOrDefault(CQLConfigOptions.EXECUTOR_SERVICE_CORE_POOL_SIZE, new String[0]);
        Integer maxPoolSize = (Integer)configuration.getOrDefault(CQLConfigOptions.EXECUTOR_SERVICE_MAX_POOL_SIZE, new String[0]);
        Long keepAliveTime = (Long)configuration.getOrDefault(CQLConfigOptions.EXECUTOR_SERVICE_KEEP_ALIVE_TIME, new String[0]);
        String executorServiceClass = (String)configuration.getOrDefault(CQLConfigOptions.EXECUTOR_SERVICE_CLASS, new String[0]);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CQLStoreManager[%02d]").build();
        if (((Boolean)configuration.get(GraphDatabaseConfiguration.BASIC_METRICS, new String[0])).booleanValue()) {
            threadFactory = ExecutorServiceInstrumentation.instrument((String)((String)configuration.get(GraphDatabaseConfiguration.METRICS_PREFIX, new String[0])), (String)"CqlStoreManager", (ThreadFactory)threadFactory);
        }
        ExecutorServiceConfiguration executorServiceConfiguration = new ExecutorServiceConfiguration(executorServiceClass, corePoolSize, maxPoolSize, keepAliveTime, threadFactory);
        ExecutorService executorService = ExecutorServiceBuilder.build((ExecutorServiceConfiguration)executorServiceConfiguration);
        if (((Boolean)configuration.get(GraphDatabaseConfiguration.BASIC_METRICS, new String[0])).booleanValue()) {
            executorService = ExecutorServiceInstrumentation.instrument((String)((String)configuration.get(GraphDatabaseConfiguration.METRICS_PREFIX, new String[0])), (String)"CqlStoreManager", (ExecutorService)executorService);
        }
        return executorService;
    }
}

