/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.function.mutate;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import io.vavr.collection.Iterator;
import io.vavr.collection.Seq;
import io.vavr.concurrent.Future;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.function.ConsumerWithBackendException;
import org.janusgraph.diskstorage.cql.function.mutate.AbstractCQLMutateManyUnloggedFunction;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.time.TimestampProvider;

public class CQLExecutorServiceMutateManyUnloggedFunction
extends AbstractCQLMutateManyUnloggedFunction {
    private final ExecutorService executorService;

    public CQLExecutorServiceMutateManyUnloggedFunction(int batchSize, CqlSession session, Map<String, CQLKeyColumnValueStore> openStores, TimestampProvider times, ExecutorService executorService, boolean assignTimestamp, ConsumerWithBackendException<DistributedStoreManager.MaskedTimestamp> sleepAfterWriteFunction) {
        super(times, assignTimestamp, session, openStores, batchSize, sleepAfterWriteFunction);
        this.executorService = executorService;
    }

    @Override
    protected Optional<Throwable> mutate(DistributedStoreManager.MaskedTimestamp commitTime, Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) {
        Future result = Future.sequence((Executor)this.executorService, (Iterable)Iterator.ofAll(mutations.entrySet()).flatMap(tableNameAndMutations -> {
            String tableName = (String)tableNameAndMutations.getKey();
            Map tableMutations = (Map)tableNameAndMutations.getValue();
            CQLKeyColumnValueStore columnValueStore = this.getColumnValueStore(tableName);
            return Iterator.ofAll(tableMutations.entrySet()).flatMap(keyAndMutations -> {
                StaticBuffer key = (StaticBuffer)keyAndMutations.getKey();
                KCVMutation keyMutations = (KCVMutation)keyAndMutations.getValue();
                return this.toGroupedBatchableStatementsSequenceIterator(commitTime, keyMutations, columnValueStore, key).map(group -> Future.fromJavaFuture((Executor)this.executorService, this.execAsyncUnlogged((Seq<BatchableStatement<BoundStatement>>)group, txh)));
            });
        }));
        result.await();
        if (result.isFailure()) {
            return Optional.of(result.getCause().get());
        }
        return Optional.empty();
    }
}

