/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.function.slice;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import java.util.concurrent.CompletableFuture;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.cql.CQLColValGetter;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.function.slice.AbstractCQLSliceFunction;

public class CQLSimpleSliceFunction
extends AbstractCQLSliceFunction {
    private final CQLColValGetter getter;

    public CQLSimpleSliceFunction(CqlSession session, PreparedStatement getSlice, CQLColValGetter getter) {
        super(session, getSlice);
        this.getter = getter;
    }

    @Override
    protected EntryList getSlice(CompletableFuture<AsyncResultSet> completableFutureSlice) throws BackendException {
        AsyncResultSet asyncResultSet = this.interruptibleWait(completableFutureSlice);
        return CQLSimpleSliceFunction.fromResultSet(asyncResultSet, this.getter);
    }

    private <T> T interruptibleWait(CompletableFuture<T> result) throws BackendException {
        try {
            return result.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PermanentBackendException((Throwable)e);
        }
        catch (Exception e) {
            throw CQLKeyColumnValueStore.EXCEPTION_MAPPER.apply(e);
        }
    }
}

