/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.servererrors.QueryValidationException;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTable;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import com.datastax.oss.driver.api.querybuilder.schema.compaction.CompactionStrategy;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.select.Selector;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.Predicates;
import io.vavr.Tuple;
import io.vavr.Tuple3;
import io.vavr.collection.Array;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLColValGetter;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.CQLResultSetKeyIterator;
import org.janusgraph.diskstorage.cql.CQLStoreManager;
import org.janusgraph.diskstorage.cql.CQLTransaction;
import org.janusgraph.diskstorage.cql.function.slice.CQLExecutorServiceSliceFunction;
import org.janusgraph.diskstorage.cql.function.slice.CQLSimpleSliceFunction;
import org.janusgraph.diskstorage.cql.function.slice.CQLSliceFunction;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySlicesIterator;
import org.janusgraph.diskstorage.keycolumnvalue.MultiSlicesQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class CQLKeyColumnValueStore
implements KeyColumnValueStore {
    public static final String TTL_FUNCTION_NAME = "ttl";
    public static final String WRITETIME_FUNCTION_NAME = "writetime";
    public static final String KEY_COLUMN_NAME = "key";
    public static final String COLUMN_COLUMN_NAME = "column1";
    public static final String VALUE_COLUMN_NAME = "value";
    public static final String WRITETIME_COLUMN_NAME = "writetime";
    public static final String TTL_COLUMN_NAME = "ttl";
    public static final String KEY_BINDING = "key";
    public static final String COLUMN_BINDING = "column1";
    public static final String VALUE_BINDING = "value";
    public static final String TIMESTAMP_BINDING = "timestamp";
    public static final String TTL_BINDING = "ttl";
    public static final String SLICE_START_BINDING = "sliceStart";
    public static final String SLICE_END_BINDING = "sliceEnd";
    public static final String KEY_START_BINDING = "keyStart";
    public static final String KEY_END_BINDING = "keyEnd";
    public static final String LIMIT_BINDING = "maxRows";
    public static final Function<? super Throwable, BackendException> EXCEPTION_MAPPER = cause -> (BackendException)API.Match((Object)cause).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(QueryValidationException.class)), PermanentBackendException::new), API.Case((API.Match.Pattern0)API.$(), TemporaryBackendException::new)});
    private final CQLStoreManager storeManager;
    private final CqlSession session;
    private final String tableName;
    private final CQLColValGetter getter;
    private final Runnable closer;
    private final PreparedStatement getKeysAll;
    private final PreparedStatement getKeysRanged;
    private final PreparedStatement deleteColumn;
    private final PreparedStatement insertColumn;
    private final PreparedStatement insertColumnWithTTL;
    private final CQLSliceFunction cqlSliceFunction;

    public CQLKeyColumnValueStore(CQLStoreManager storeManager, String tableName, Configuration configuration, Runnable closer) {
        this.storeManager = storeManager;
        this.tableName = tableName;
        this.closer = closer;
        this.session = this.storeManager.getSession();
        this.getter = new CQLColValGetter(storeManager.getMetaDataSchema(this.tableName));
        if (this.shouldInitializeTable()) {
            CQLKeyColumnValueStore.initializeTable(this.session, this.storeManager.getKeyspaceName(), tableName, configuration);
        }
        Select getSliceSelect = ((Select)QueryBuilder.selectFrom((String)this.storeManager.getKeyspaceName(), (String)this.tableName).column("column1").column("value").where(new Relation[]{(Relation)Relation.column((String)"key").isEqualTo((Term)QueryBuilder.bindMarker((String)"key")), (Relation)Relation.column((String)"column1").isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)SLICE_START_BINDING)), (Relation)Relation.column((String)"column1").isLessThan((Term)QueryBuilder.bindMarker((String)SLICE_END_BINDING))})).limit(QueryBuilder.bindMarker((String)LIMIT_BINDING));
        PreparedStatement getSlice = this.session.prepare(this.addTTLFunction(this.addTimestampFunction(getSliceSelect)).build());
        if (this.storeManager.getFeatures().hasOrderedScan()) {
            Select getKeysRangedSelect = (Select)((Select)((Select)QueryBuilder.selectFrom((String)this.storeManager.getKeyspaceName(), (String)this.tableName).column("key").column("column1").column("value").allowFiltering().where(new Relation[]{(Relation)Relation.token((String[])new String[]{"key"}).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)KEY_START_BINDING)), (Relation)Relation.token((String[])new String[]{"key"}).isLessThan((Term)QueryBuilder.bindMarker((String)KEY_END_BINDING))})).whereColumn("column1").isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)SLICE_START_BINDING))).whereColumn("column1").isLessThanOrEqualTo((Term)QueryBuilder.bindMarker((String)SLICE_END_BINDING));
            this.getKeysRanged = this.session.prepare(this.addTTLFunction(this.addTimestampFunction(getKeysRangedSelect)).build());
        } else {
            this.getKeysRanged = null;
        }
        if (this.storeManager.getFeatures().hasUnorderedScan()) {
            Select getKeysAllSelect = (Select)((Select)QueryBuilder.selectFrom((String)this.storeManager.getKeyspaceName(), (String)this.tableName).column("key").column("column1").column("value").allowFiltering().whereColumn("column1").isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)SLICE_START_BINDING))).whereColumn("column1").isLessThanOrEqualTo((Term)QueryBuilder.bindMarker((String)SLICE_END_BINDING));
            this.getKeysAll = this.session.prepare(this.addTTLFunction(this.addTimestampFunction(getKeysAllSelect)).build());
        } else {
            this.getKeysAll = null;
        }
        DeleteSelection deleteSelection = this.addUsingTimestamp(QueryBuilder.deleteFrom((String)this.storeManager.getKeyspaceName(), (String)this.tableName));
        this.deleteColumn = this.session.prepare(((Delete)((Delete)deleteSelection.whereColumn("key").isEqualTo((Term)QueryBuilder.bindMarker((String)"key"))).whereColumn("column1").isEqualTo((Term)QueryBuilder.bindMarker((String)"column1"))).build());
        Insert insertColumnInsert = this.addUsingTimestamp((Insert)QueryBuilder.insertInto((String)this.storeManager.getKeyspaceName(), (String)this.tableName).value("key", (Term)QueryBuilder.bindMarker((String)"key")).value("column1", (Term)QueryBuilder.bindMarker((String)"column1")).value("value", (Term)QueryBuilder.bindMarker((String)"value")));
        this.insertColumn = this.session.prepare(insertColumnInsert.build());
        this.insertColumnWithTTL = storeManager.getFeatures().hasCellTTL() ? this.session.prepare(insertColumnInsert.usingTtl(QueryBuilder.bindMarker((String)"ttl")).build()) : null;
        Optional<ExecutorService> executorService = this.storeManager.getExecutorService();
        this.cqlSliceFunction = executorService.isPresent() ? new CQLExecutorServiceSliceFunction(this.session, getSlice, this.getter, executorService.get()) : new CQLSimpleSliceFunction(this.session, getSlice, this.getter);
    }

    private DeleteSelection addUsingTimestamp(DeleteSelection deleteSelection) {
        if (this.storeManager.isAssignTimestamp()) {
            return deleteSelection.usingTimestamp(QueryBuilder.bindMarker((String)TIMESTAMP_BINDING));
        }
        return deleteSelection;
    }

    private Insert addUsingTimestamp(Insert insert) {
        if (this.storeManager.isAssignTimestamp()) {
            return insert.usingTimestamp(QueryBuilder.bindMarker((String)TIMESTAMP_BINDING));
        }
        return insert;
    }

    private Select addTimestampFunction(Select select) {
        if (((Boolean)this.storeManager.getStorageConfig().get(GraphDatabaseConfiguration.STORE_META_TIMESTAMPS, new String[]{this.tableName})).booleanValue()) {
            return select.function("writetime", new Selector[]{Selector.column((String)"value")}).as("writetime");
        }
        return select;
    }

    private Select addTTLFunction(Select select) {
        if (((Boolean)this.storeManager.getStorageConfig().get(GraphDatabaseConfiguration.STORE_META_TTL, new String[]{this.tableName})).booleanValue()) {
            return select.function("ttl", new Selector[]{Selector.column((String)"value")}).as("ttl");
        }
        return select;
    }

    private boolean shouldInitializeTable() {
        return this.storeManager.getSession().getMetadata().getKeyspace(this.storeManager.getKeyspaceName()).map(k -> !k.getTable(this.tableName).isPresent()).orElse(true);
    }

    private static void initializeTable(CqlSession session, String keyspaceName, String tableName, Configuration configuration) {
        CreateTable createTable = SchemaBuilder.createTable((String)keyspaceName, (String)tableName).ifNotExists().withPartitionKey("key", DataTypes.BLOB).withClusteringColumn("column1", DataTypes.BLOB).withColumn("value", DataTypes.BLOB);
        createTable = CQLKeyColumnValueStore.compactionOptions((CreateTableWithOptions)createTable, configuration);
        createTable = CQLKeyColumnValueStore.compressionOptions((CreateTableWithOptions)createTable, configuration);
        createTable = CQLKeyColumnValueStore.gcGraceSeconds((CreateTableWithOptions)createTable, configuration);
        createTable = CQLKeyColumnValueStore.speculativeRetryOptions((CreateTableWithOptions)createTable, configuration);
        session.execute((Statement)createTable.build());
    }

    private static CreateTableWithOptions compressionOptions(CreateTableWithOptions createTable, Configuration configuration) {
        if (!((Boolean)configuration.get(CQLConfigOptions.CF_COMPRESSION, new String[0])).booleanValue()) {
            return (CreateTableWithOptions)createTable.withNoCompression();
        }
        String compressionType = (String)configuration.get(CQLConfigOptions.CF_COMPRESSION_TYPE, new String[0]);
        int chunkLengthInKb = (Integer)configuration.get(CQLConfigOptions.CF_COMPRESSION_BLOCK_SIZE, new String[0]);
        return (CreateTableWithOptions)createTable.withOption("compression", (Object)ImmutableMap.of((Object)"sstable_compression", (Object)compressionType, (Object)"chunk_length_kb", (Object)chunkLengthInKb));
    }

    static CreateTableWithOptions compactionOptions(CreateTableWithOptions createTable, Configuration configuration) {
        if (!configuration.has(CQLConfigOptions.COMPACTION_STRATEGY, new String[0])) {
            return createTable;
        }
        CompactionStrategy compactionStrategy = (CompactionStrategy)API.Match((Object)configuration.get(CQLConfigOptions.COMPACTION_STRATEGY, new String[0])).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Object)"SizeTieredCompactionStrategy"), (Object)SchemaBuilder.sizeTieredCompactionStrategy()), API.Case((API.Match.Pattern0)API.$((Object)"TimeWindowCompactionStrategy"), (Object)SchemaBuilder.timeWindowCompactionStrategy()), API.Case((API.Match.Pattern0)API.$((Object)"LeveledCompactionStrategy"), (Object)SchemaBuilder.leveledCompactionStrategy())});
        if (configuration.has(CQLConfigOptions.COMPACTION_OPTIONS, new String[0])) {
            io.vavr.collection.Iterator groupedOptions = Array.of((Object[])((Object[])configuration.get(CQLConfigOptions.COMPACTION_OPTIONS, new String[0]))).grouped(2);
            for (Array keyValue : groupedOptions) {
                compactionStrategy = (CompactionStrategy)compactionStrategy.withOption((String)keyValue.get(0), keyValue.get(1));
            }
        }
        return (CreateTableWithOptions)createTable.withCompaction(compactionStrategy);
    }

    private static CreateTableWithOptions gcGraceSeconds(CreateTableWithOptions createTable, Configuration configuration) {
        if (!configuration.has(CQLConfigOptions.GC_GRACE_SECONDS, new String[0])) {
            return createTable;
        }
        return (CreateTableWithOptions)createTable.withGcGraceSeconds(((Integer)configuration.get(CQLConfigOptions.GC_GRACE_SECONDS, new String[0])).intValue());
    }

    private static CreateTableWithOptions speculativeRetryOptions(CreateTableWithOptions createTable, Configuration configuration) {
        if (!configuration.has(CQLConfigOptions.SPECULATIVE_RETRY, new String[0])) {
            return createTable;
        }
        return (CreateTableWithOptions)createTable.withSpeculativeRetry((String)configuration.get(CQLConfigOptions.SPECULATIVE_RETRY, new String[0]));
    }

    public void close() throws BackendException {
        this.closer.run();
    }

    public String getName() {
        return this.tableName;
    }

    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        return this.cqlSliceFunction.getSlice(query, txh);
    }

    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException("The CQL backend does not support multi-key queries");
    }

    public BatchableStatement<BoundStatement> deleteColumn(StaticBuffer key, StaticBuffer column) {
        return this.deleteColumn(key, column, null);
    }

    public BatchableStatement<BoundStatement> deleteColumn(StaticBuffer key, StaticBuffer column, Long timestamp) {
        BoundStatementBuilder builder = (BoundStatementBuilder)((BoundStatementBuilder)this.deleteColumn.boundStatementBuilder(new Object[0]).setByteBuffer("key", key.asByteBuffer())).setByteBuffer("column1", column.asByteBuffer());
        if (timestamp != null) {
            builder = (BoundStatementBuilder)builder.setLong(TIMESTAMP_BINDING, timestamp.longValue());
        }
        return builder.build();
    }

    public BatchableStatement<BoundStatement> insertColumn(StaticBuffer key, Entry entry) {
        return this.insertColumn(key, entry, null);
    }

    public BatchableStatement<BoundStatement> insertColumn(StaticBuffer key, Entry entry, Long timestamp) {
        Integer ttl = (Integer)entry.getMetaData().get(EntryMetaData.TTL);
        BoundStatementBuilder builder = ttl != null ? this.insertColumnWithTTL.boundStatementBuilder(new Object[0]) : this.insertColumn.boundStatementBuilder(new Object[0]);
        builder = (BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)builder.setByteBuffer("key", key.asByteBuffer())).setByteBuffer("column1", entry.getColumn().asByteBuffer())).setByteBuffer("value", entry.getValue().asByteBuffer());
        if (ttl != null) {
            builder = (BoundStatementBuilder)builder.setInt("ttl", ttl.intValue());
        }
        if (timestamp != null) {
            builder = (BoundStatementBuilder)builder.setLong(TIMESTAMP_BINDING, timestamp.longValue());
        }
        return builder.build();
    }

    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        this.storeManager.mutateMany(Collections.singletonMap(this.tableName, Collections.singletonMap(key, new KCVMutation(additions, deletions))), txh);
    }

    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        boolean hasLocking = this.storeManager.getFeatures().hasLocking();
        if (!hasLocking) {
            throw new UnsupportedOperationException(String.format("%s doesn't support locking", this.getClass()));
        }
    }

    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) throws BackendException {
        if (!this.storeManager.getFeatures().hasOrderedScan()) {
            throw new PermanentBackendException("This operation is only allowed when the byteorderedpartitioner is used.");
        }
        TokenMap tokenMap = (TokenMap)this.session.getMetadata().getTokenMap().get();
        return (KeyIterator)Try.of((CheckedFunction0 & Serializable)() -> new CQLResultSetKeyIterator((SliceQuery)query, this.getter, (Iterable<Row>)((Object)new CQLPagingIterator(((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.getKeysRanged.boundStatementBuilder(new Object[0]).setToken(KEY_START_BINDING, tokenMap.newToken(new ByteBuffer[]{query.getKeyStart().asByteBuffer()}))).setToken(KEY_END_BINDING, tokenMap.newToken(new ByteBuffer[]{query.getKeyEnd().asByteBuffer()}))).setByteBuffer(SLICE_START_BINDING, query.getSliceStart().asByteBuffer())).setByteBuffer(SLICE_END_BINDING, query.getSliceEnd().asByteBuffer())).setPageSize(this.storeManager.getPageSize())).setConsistencyLevel(CQLTransaction.getTransaction(txh).getReadConsistencyLevel())).build())))).getOrElseThrow(EXCEPTION_MAPPER);
    }

    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) throws BackendException {
        if (!this.storeManager.getFeatures().hasUnorderedScan()) {
            throw new PermanentBackendException("This operation is only allowed when a random partitioner (md5 or murmur3) is used.");
        }
        return (KeyIterator)Try.of((CheckedFunction0 & Serializable)() -> new CQLResultSetKeyIterator(query, this.getter, (Iterable<Row>)((Object)new CQLPagingIterator(((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.getKeysAll.boundStatementBuilder(new Object[0]).setByteBuffer(SLICE_START_BINDING, query.getSliceStart().asByteBuffer())).setByteBuffer(SLICE_END_BINDING, query.getSliceEnd().asByteBuffer())).setPageSize(this.storeManager.getPageSize())).setConsistencyLevel(CQLTransaction.getTransaction(txh).getReadConsistencyLevel())).build())))).getOrElseThrow(EXCEPTION_MAPPER);
    }

    public KeySlicesIterator getKeys(MultiSlicesQuery queries, StoreTransaction txh) throws BackendException {
        throw new UnsupportedOperationException();
    }

    private class CQLPagingIterator
    implements io.vavr.collection.Iterator<Row> {
        private final List<ExecutionInfo> dseStoredExecutionInfos;
        private final Iterator<Row> currentPageIterator;

        public CQLPagingIterator(BoundStatement boundStatement) {
            ResultSet currentResultSet = CQLKeyColumnValueStore.this.session.execute((Statement)boundStatement);
            this.currentPageIterator = currentResultSet.iterator();
            this.dseStoredExecutionInfos = currentResultSet.getExecutionInfos();
        }

        public boolean hasNext() {
            return this.currentPageIterator.hasNext();
        }

        public Row next() {
            if (this.dseStoredExecutionInfos.size() > 1) {
                ExecutionInfo lastExecutionInfo = this.dseStoredExecutionInfos.get(this.dseStoredExecutionInfos.size() - 1);
                this.dseStoredExecutionInfos.clear();
                this.dseStoredExecutionInfos.add(lastExecutionInfo);
            }
            return this.currentPageIterator.next();
        }
    }

    public static class CQLResultSetIterator
    implements RecordIterator<Tuple3<StaticBuffer, StaticBuffer, Row>> {
        private Iterator<Row> resultSetIterator;

        public CQLResultSetIterator(ResultSet rs) {
            this.resultSetIterator = rs.iterator();
        }

        public boolean hasNext() {
            return this.resultSetIterator.hasNext();
        }

        public Tuple3<StaticBuffer, StaticBuffer, Row> next() {
            Row nextRow = this.resultSetIterator.next();
            return nextRow == null ? null : Tuple.of((Object)StaticArrayBuffer.of((ByteBuffer)nextRow.getByteBuffer("column1")), (Object)StaticArrayBuffer.of((ByteBuffer)nextRow.getByteBuffer("value")), (Object)nextRow);
        }

        public void close() throws IOException {
        }
    }
}

