/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.builder;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.builder.CQLStoreFeaturesWrapper;
import org.janusgraph.diskstorage.keycolumnvalue.StandardStoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.util.system.NetworkUtil;

public class CQLStoreFeaturesBuilder {
    public CQLStoreFeaturesWrapper build(CqlSession session, Configuration configuration, String[] hostnames) {
        DistributedStoreManager.Deployment deployment;
        ModifiableConfiguration global = GraphDatabaseConfiguration.buildGraphConfiguration().set(CQLConfigOptions.READ_CONSISTENCY, (Object)"QUORUM", new String[0]).set(CQLConfigOptions.WRITE_CONSISTENCY, (Object)"QUORUM", new String[0]).set(GraphDatabaseConfiguration.METRICS_PREFIX, (Object)"org.janusgraph.sys", new String[0]);
        ModifiableConfiguration local = GraphDatabaseConfiguration.buildGraphConfiguration().set(CQLConfigOptions.READ_CONSISTENCY, (Object)"LOCAL_QUORUM", new String[0]).set(CQLConfigOptions.WRITE_CONSISTENCY, (Object)"LOCAL_QUORUM", new String[0]).set(GraphDatabaseConfiguration.METRICS_PREFIX, (Object)"org.janusgraph.sys", new String[0]);
        Boolean onlyUseLocalConsistency = (Boolean)configuration.get(CQLConfigOptions.ONLY_USE_LOCAL_CONSISTENCY_FOR_SYSTEM_OPERATIONS, new String[0]);
        Boolean useExternalLocking = (Boolean)configuration.get(CQLConfigOptions.USE_EXTERNAL_LOCKING, new String[0]);
        StandardStoreFeatures.Builder fb = new StandardStoreFeatures.Builder();
        fb.batchMutation(true).distributed(true);
        fb.timestamps(true).cellTTL(true);
        fb.keyConsistent((Configuration)(onlyUseLocalConsistency != false ? local : global), (Configuration)local);
        fb.locking(useExternalLocking.booleanValue());
        fb.optimisticLocking(true);
        fb.multiQuery(false);
        String partitioner = null;
        if (configuration.has(CQLConfigOptions.PARTITIONER_NAME, new String[0])) {
            partitioner = this.getShortPartitionerName((String)configuration.get(CQLConfigOptions.PARTITIONER_NAME, new String[0]));
        }
        if (session.getMetadata().getTokenMap().isPresent()) {
            String retrievedPartitioner = this.getShortPartitionerName(((TokenMap)session.getMetadata().getTokenMap().get()).getPartitionerName());
            if (partitioner == null) {
                partitioner = retrievedPartitioner;
            } else if (!partitioner.equals(retrievedPartitioner)) {
                throw new IllegalArgumentException(String.format("Provided partitioner (%s) does not match with server (%s)", partitioner, retrievedPartitioner));
            }
        } else if (partitioner == null) {
            throw new IllegalArgumentException(String.format("Partitioner name not provided and cannot retrieve it from server, please check %s and %s options", CQLConfigOptions.PARTITIONER_NAME.getName(), CQLConfigOptions.METADATA_TOKEN_MAP_ENABLED.getName()));
        }
        switch (partitioner) {
            case "DefaultPartitioner": {
                fb.timestamps(false);
            }
            case "RandomPartitioner": 
            case "Murmur3Partitioner": {
                fb.keyOrdered(false).orderedScan(false).unorderedScan(true);
                deployment = DistributedStoreManager.Deployment.REMOTE;
                break;
            }
            case "ByteOrderedPartitioner": {
                fb.keyOrdered(true).orderedScan(true).unorderedScan(false);
                deployment = hostnames.length == 1 ? (NetworkUtil.isLocalConnection((String)hostnames[0]) ? DistributedStoreManager.Deployment.LOCAL : DistributedStoreManager.Deployment.REMOTE) : DistributedStoreManager.Deployment.REMOTE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized partitioner: " + partitioner);
            }
        }
        StandardStoreFeatures storeFeatures = fb.build();
        return new CQLStoreFeaturesWrapper((StoreFeatures)storeFeatures, deployment);
    }

    private String getShortPartitionerName(String partitioner) {
        if (partitioner == null) {
            return null;
        }
        return partitioner.substring(partitioner.lastIndexOf(46) + 1);
    }
}

