/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.function.mutate;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.CQLTransaction;
import org.janusgraph.diskstorage.cql.function.ConsumerWithBackendException;
import org.janusgraph.diskstorage.cql.function.mutate.AbstractCQLMutateManyFunction;
import org.janusgraph.diskstorage.cql.function.mutate.CQLMutateManyFunction;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.backpressure.QueryBackPressure;
import org.janusgraph.diskstorage.util.time.TimestampProvider;

public class CQLMutateManyLoggedFunction
extends AbstractCQLMutateManyFunction
implements CQLMutateManyFunction {
    private final CqlSession session;
    private final QueryBackPressure queryBackPressure;

    public CQLMutateManyLoggedFunction(TimestampProvider times, boolean assignTimestamp, Map<String, CQLKeyColumnValueStore> openStores, CqlSession session, ConsumerWithBackendException<DistributedStoreManager.MaskedTimestamp> sleepAfterWriteFunction, QueryBackPressure queryBackPressure) {
        super(sleepAfterWriteFunction, assignTimestamp, times, openStores);
        this.session = session;
        this.queryBackPressure = queryBackPressure;
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        DistributedStoreManager.MaskedTimestamp commitTime = (DistributedStoreManager.MaskedTimestamp)this.createMaskedTimestampFunction.apply(txh);
        BatchStatementBuilder builder = BatchStatement.builder((BatchType)DefaultBatchType.LOGGED);
        builder.setConsistencyLevel(CQLTransaction.getTransaction(txh).getWriteConsistencyLevel());
        mutations.forEach((tableName, tableMutations) -> {
            CQLKeyColumnValueStore columnValueStore = this.getColumnValueStore((String)tableName);
            tableMutations.forEach((key, keyMutations) -> {
                this.deletionsFunction.getBatchableStatementsForColumnOperation(commitTime, (KCVMutation)keyMutations, columnValueStore, (StaticBuffer)key).forEach(arg_0 -> ((BatchStatementBuilder)builder).addStatement(arg_0));
                this.additionsFunction.getBatchableStatementsForColumnOperation(commitTime, (KCVMutation)keyMutations, columnValueStore, (StaticBuffer)key).forEach(arg_0 -> ((BatchStatementBuilder)builder).addStatement(arg_0));
            });
        });
        this.execute(builder.build());
        this.sleepAfterWriteFunction.accept(commitTime);
    }

    private void execute(BatchStatement batchStatement) throws BackendException {
        this.queryBackPressure.acquireBeforeQuery();
        try {
            this.session.execute((Statement)batchStatement);
        }
        catch (Throwable throwable) {
            throw CQLKeyColumnValueStore.EXCEPTION_MAPPER.apply(throwable);
        }
        finally {
            this.queryBackPressure.releaseAfterQuery();
        }
    }
}

