/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.function.slice;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import org.janusgraph.diskstorage.cql.CQLColValGetter;
import org.janusgraph.diskstorage.cql.function.slice.AsyncCQLFunction;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.util.backpressure.QueryBackPressure;

public class AsyncCQLSingleKeySliceFunction
extends AsyncCQLFunction<KeySliceQuery> {
    public AsyncCQLSingleKeySliceFunction(CqlSession session, PreparedStatement getSlice, CQLColValGetter getter, ExecutorService executorService, QueryBackPressure queryBackPressure) {
        super(session, getSlice, getter, executorService, queryBackPressure);
    }

    @Override
    BoundStatementBuilder bindMarkers(KeySliceQuery query, BoundStatementBuilder statementBuilder) {
        ByteBuffer key = query.getKey().asByteBuffer();
        return (BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)statementBuilder.setByteBuffer("key", key)).setByteBuffer("sliceStart", query.getSliceStart().asByteBuffer())).setByteBuffer("sliceEnd", query.getSliceEnd().asByteBuffer())).setInt("maxRows", query.getLimit())).setRoutingKey(key);
    }
}

