/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop;

import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.graphdb.tinkerpop.io.JanusGraphP;

public class JanusGraphPSerializer
extends Serializer<JanusGraphP> {
    public void write(Kryo kryo, Output output, JanusGraphP p) {
        output.writeString(p.getBiPredicate().toString());
        kryo.writeClassAndObject(output, p.getValue());
    }

    public JanusGraphP read(Kryo kryo, Input input, Class<JanusGraphP> aClass) {
        String predicate = input.readString();
        Object value = kryo.readClassAndObject(input);
        return JanusGraphPSerializer.createPredicateWithValue(predicate, value);
    }

    public static boolean checkForJanusGraphPredicate(String predicateName) {
        switch (predicateName) {
            case "geoIntersect": 
            case "geoDisjoint": 
            case "geoWithin": 
            case "geoContains": 
            case "textContains": 
            case "textContainsFuzzy": 
            case "textContainsPrefix": 
            case "textContainsRegex": 
            case "textFuzzy": 
            case "textPrefix": 
            case "textRegex": {
                return true;
            }
        }
        return false;
    }

    public static JanusGraphP createPredicateWithValue(String predicateName, Object value) {
        switch (predicateName) {
            case "geoIntersect": {
                return Geo.geoIntersect(value);
            }
            case "geoDisjoint": {
                return Geo.geoDisjoint(value);
            }
            case "geoWithin": {
                return Geo.geoWithin(value);
            }
            case "geoContains": {
                return Geo.geoContains(value);
            }
            case "textContains": {
                return Text.textContains(value);
            }
            case "textContainsFuzzy": {
                return Text.textContainsFuzzy(value);
            }
            case "textContainsPrefix": {
                return Text.textContainsPrefix(value);
            }
            case "textContainsRegex": {
                return Text.textContainsRegex(value);
            }
            case "textFuzzy": {
                return Text.textFuzzy(value);
            }
            case "textPrefix": {
                return Text.textPrefix(value);
            }
            case "textRegex": {
                return Text.textRegex(value);
            }
        }
        throw new UnsupportedOperationException("Matched predicate {" + predicateName + "} is not support by JanusGraphPSerializer");
    }
}

