/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.graphson;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TinkerPopJacksonModule;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.core.type.WritableTypeId;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.tinkerpop.DeprecatedJanusGraphPSerializer;
import org.janusgraph.graphdb.tinkerpop.JanusGraphPSerializer;
import org.janusgraph.graphdb.tinkerpop.io.JanusGraphP;

public abstract class JanusGraphSONModule
extends TinkerPopJacksonModule {
    private static final String TYPE_NAMESPACE = "janusgraph";
    private static final Map<Class, String> TYPE_DEFINITIONS = Collections.unmodifiableMap(new LinkedHashMap<Class, String>(){
        {
            this.put(RelationIdentifier.class, "RelationIdentifier");
            this.put(Geoshape.class, "Geoshape");
            this.put(JanusGraphP.class, "JanusGraphP");
        }
    });

    protected JanusGraphSONModule() {
        super(TYPE_NAMESPACE);
    }

    public Map<Class, String> getTypeDefinitions() {
        return TYPE_DEFINITIONS;
    }

    public String getTypeNamespace() {
        return TYPE_NAMESPACE;
    }

    @Deprecated
    public static class DeprecatedJanusGraphPDeserializerV2d0
    extends StdDeserializer<P> {
        public DeprecatedJanusGraphPDeserializerV2d0() {
            super(P.class);
        }

        public P deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String predicate = null;
            Object value = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("predicate")) {
                    jsonParser.nextToken();
                    predicate = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                value = deserializationContext.readValue(jsonParser, Object.class);
            }
            try {
                return DeprecatedJanusGraphPSerializer.createPredicateWithValue(predicate, value);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        public boolean isCachable() {
            return true;
        }
    }

    public static class JanusGraphPDeserializerV2d0
    extends AbstractObjectDeserializer<JanusGraphP> {
        public JanusGraphPDeserializerV2d0() {
            super(JanusGraphP.class);
        }

        public JanusGraphP createObject(Map<String, Object> data) {
            String predicate = (String)data.get("predicate");
            Object value = data.get("value");
            return JanusGraphPSerializer.createPredicateWithValue(predicate, value);
        }

        public boolean isCachable() {
            return true;
        }
    }

    public static class JanusGraphPSerializerV2d0
    extends StdSerializer<JanusGraphP> {
        public JanusGraphPSerializerV2d0() {
            super(JanusGraphP.class);
        }

        public void serialize(JanusGraphP predicate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(predicate.toString());
        }

        public void serializeWithType(JanusGraphP value, JsonGenerator jgen, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            String predicateName = value.getBiPredicate().toString();
            Object arg = value.getValue();
            jgen.writeStartObject();
            if (typeSerializer != null) {
                jgen.writeStringField("@type", "janusgraph:" + (String)TYPE_DEFINITIONS.get(JanusGraphP.class));
            }
            jgen.writeFieldName("@value");
            GraphSONUtil.writeStartObject((Object)((Object)value), (JsonGenerator)jgen, (TypeSerializer)typeSerializer);
            GraphSONUtil.writeWithType((String)"predicate", (Object)predicateName, (JsonGenerator)jgen, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            GraphSONUtil.writeWithType((String)"value", (Object)arg, (JsonGenerator)jgen, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            GraphSONUtil.writeEndObject((Object)((Object)value), (JsonGenerator)jgen, (TypeSerializer)typeSerializer);
            jgen.writeEndObject();
        }
    }

    public static class RelationIdentifierDeserializerV2d0
    extends AbstractObjectDeserializer<RelationIdentifier> {
        public RelationIdentifierDeserializerV2d0() {
            super(RelationIdentifier.class);
        }

        public RelationIdentifier createObject(Map data) {
            return RelationIdentifier.parse((String)data.get("relationId"));
        }
    }

    public static class RelationIdentifierSerializerV2d0
    extends StdSerializer<RelationIdentifier> {
        public RelationIdentifierSerializerV2d0() {
            super(RelationIdentifier.class);
        }

        public void serialize(RelationIdentifier relationIdentifier, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(relationIdentifier.toString());
        }

        public void serializeWithType(RelationIdentifier relationIdentifier, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            jsonGenerator.writeStartObject();
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@type", "janusgraph:" + (String)TYPE_DEFINITIONS.get(RelationIdentifier.class));
            }
            jsonGenerator.writeFieldName("@value");
            GraphSONUtil.writeStartObject((Object)relationIdentifier, (JsonGenerator)jsonGenerator, (TypeSerializer)typeSerializer);
            GraphSONUtil.writeWithType((String)"relationId", (Object)relationIdentifier.toString(), (JsonGenerator)jsonGenerator, (SerializerProvider)serializerProvider, (TypeSerializer)typeSerializer);
            GraphSONUtil.writeEndObject((Object)relationIdentifier, (JsonGenerator)jsonGenerator, (TypeSerializer)typeSerializer);
            jsonGenerator.writeEndObject();
        }
    }

    public static class RelationIdentifierDeserializerV1d0
    extends StdDeserializer<RelationIdentifier> {
        public RelationIdentifierDeserializerV1d0() {
            super(RelationIdentifier.class);
        }

        public RelationIdentifier deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            jsonParser.nextToken();
            Map mapData = (Map)deserializationContext.readValue(jsonParser, Map.class);
            return RelationIdentifier.parse((String)mapData.get("value"));
        }
    }

    public static class RelationIdentifierSerializerV1d0
    extends StdSerializer<RelationIdentifier> {
        public RelationIdentifierSerializerV1d0() {
            super(RelationIdentifier.class);
        }

        public void serialize(RelationIdentifier relationIdentifier, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(relationIdentifier.toString());
        }

        public void serializeWithType(RelationIdentifier relationIdentifier, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            WritableTypeId typeIdDef = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId((Object)relationIdentifier, JsonToken.VALUE_STRING));
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("value", relationIdentifier.toString());
            jsonGenerator.writeStringField("@class", HashMap.class.getName());
            jsonGenerator.writeEndObject();
            typeSerializer.writeTypeSuffix(jsonGenerator, typeIdDef);
        }
    }
}

