/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary.geoshape;

import java.util.ArrayList;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.janusgraph.core.attribute.Geoshape;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

class PointCollectionSerializer {
    PointCollectionSerializer() {
    }

    public List<double[]> readPoints(Buffer buffer) {
        int length = buffer.readInt();
        ArrayList<double[]> points = new ArrayList<double[]>(length);
        for (int i = 0; i < length; ++i) {
            double y = buffer.readDouble();
            double x = buffer.readDouble();
            points.add(new double[]{x, y});
        }
        return points;
    }

    public void writePointCollectionGeoshape(Geoshape geoshape, Buffer buffer) {
        Shape shape = geoshape.getShape();
        Geometry geom = ((JtsGeometry)shape).getGeom();
        this.writePoints(geom.getCoordinates(), buffer);
    }

    public void writePoints(Coordinate[] points, Buffer buffer) {
        buffer.writeInt(points.length);
        for (Coordinate coordinate : points) {
            buffer.writeDouble(coordinate.getY());
            buffer.writeDouble(coordinate.getX());
        }
    }
}

