/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ElasticMajorVersion {
    ONE(1),
    TWO(2),
    FIVE(5),
    SIX(6);

    static final Pattern PATTERN;
    final int value;

    private ElasticMajorVersion(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ElasticMajorVersion parse(String value) {
        Matcher m = value != null ? PATTERN.matcher(value) : null;
        switch (m != null && m.find() ? Integer.valueOf(m.group(1)) : -1) {
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 5: {
                return FIVE;
            }
            case 6: {
                return SIX;
            }
        }
        throw new IllegalArgumentException("Unsupported Elasticsearch server major version: " + value);
    }

    static {
        PATTERN = Pattern.compile("(\\d+)\\.\\d+\\.\\d+.*");
    }
}

