/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransaction;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.BaseTransactionConfigurable;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.es.ElasticMajorVersion;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchMutation;
import org.janusgraph.diskstorage.es.ElasticSearchRequest;
import org.janusgraph.diskstorage.es.ElasticSearchResponse;
import org.janusgraph.diskstorage.es.ElasticSearchScroll;
import org.janusgraph.diskstorage.es.ElasticSearchSetup;
import org.janusgraph.diskstorage.es.compat.AbstractESCompat;
import org.janusgraph.diskstorage.es.compat.ESCompatUtils;
import org.janusgraph.diskstorage.es.mapping.IndexMapping;
import org.janusgraph.diskstorage.es.rest.util.HttpAuthTypes;
import org.janusgraph.diskstorage.es.script.ESScriptResponse;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexMutation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.diskstorage.util.DefaultTransaction;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.PreInitializeConfigOptions;
import org.janusgraph.graphdb.database.serialize.AttributeUtils;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.Not;
import org.janusgraph.graphdb.query.condition.Or;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.types.ParameterType;
import org.locationtech.spatial4j.shape.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class ElasticSearchIndex
implements IndexProvider {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchIndex.class);
    private static final String STRING_MAPPING_SUFFIX = "__STRING";
    public static final ConfigNamespace ELASTICSEARCH_NS = new ConfigNamespace(GraphDatabaseConfiguration.INDEX_NS, "elasticsearch", "Elasticsearch index configuration");
    public static final ConfigOption<String> INTERFACE = new ConfigOption(ELASTICSEARCH_NS, "interface", "Interface for connecting to Elasticsearch. TRANSPORT_CLIENT and NODE were previously supported, but now are required to migrate to REST_CLIENT. See the JanusGraph upgrade instructions for more details.", ConfigOption.Type.MASKABLE, String.class, (Object)ElasticSearchSetup.REST_CLIENT.toString(), ConfigOption.disallowEmpty(String.class));
    public static final ConfigOption<String> HEALTH_REQUEST_TIMEOUT = new ConfigOption(ELASTICSEARCH_NS, "health-request-timeout", "When JanusGraph initializes its ES backend, JanusGraph waits up to this duration for the ES cluster health to reach at least yellow status.  This string should be formatted as a natural number followed by the lowercase letter \"s\", e.g. 3s or 60s.", ConfigOption.Type.MASKABLE, (Object)"30s");
    public static final ConfigOption<String> BULK_REFRESH = new ConfigOption(ELASTICSEARCH_NS, "bulk-refresh", "Elasticsearch bulk API refresh setting used to control when changes made by this request are made visible to search", ConfigOption.Type.MASKABLE, (Object)"false");
    public static final ConfigNamespace ES_CREATE_NS = new ConfigNamespace(ELASTICSEARCH_NS, "create", "Settings related to index creation");
    public static final ConfigOption<Long> CREATE_SLEEP = new ConfigOption(ES_CREATE_NS, "sleep", "How long to sleep, in milliseconds, between the successful completion of a (blocking) index creation request and the first use of that index.  This only applies when creating an index in ES, which typically only happens the first time JanusGraph is started on top of ES. If the index JanusGraph is configured to use already exists, then this setting has no effect.", ConfigOption.Type.MASKABLE, (Object)200L);
    public static final ConfigNamespace ES_CREATE_EXTRAS_NS = new ConfigNamespace(ES_CREATE_NS, "ext", "Overrides for arbitrary settings applied at index creation", true);
    public static final ConfigOption<Boolean> USE_EXTERNAL_MAPPINGS = new ConfigOption(ES_CREATE_NS, "use-external-mappings", "Whether JanusGraph should make use of an external mapping when registering an index.", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<Boolean> ALLOW_MAPPING_UPDATE = new ConfigOption(ES_CREATE_NS, "allow-mapping-update", "Whether JanusGraph should allow a mapping update when registering an index. Only applicable when " + USE_EXTERNAL_MAPPINGS.getName() + " is true.", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<Boolean> USE_ALL_FIELD = new ConfigOption(ELASTICSEARCH_NS, "use-all-field", "Whether JanusGraph should add an \"all\" field mapping. When enabled field mappings will include a \"copy_to\" parameter referencing the \"all\" field. This is supported since Elasticsearch 6.x  and is required when using wildcard fields starting in Elasticsearch 6.x.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)true);
    public static final ConfigOption<Integer> ES_SCROLL_KEEP_ALIVE = new ConfigOption(ELASTICSEARCH_NS, "scroll-keep-alive", "How long (in seconds) elasticsearch should keep alive the scroll context.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)60);
    public static final ConfigNamespace ES_INGEST_PIPELINES = new ConfigNamespace(ELASTICSEARCH_NS, "ingest-pipeline", "Ingest pipeline applicable to a store of an index.");
    public static final ConfigNamespace SSL_NS = new ConfigNamespace(ELASTICSEARCH_NS, "ssl", "Elasticsearch SSL configuration");
    public static final ConfigOption<Boolean> SSL_ENABLED = new ConfigOption(SSL_NS, "enabled", "Controls use of the SSL connection to Elasticsearch.", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<Boolean> SSL_DISABLE_HOSTNAME_VERIFICATION = new ConfigOption(SSL_NS, "disable-hostname-verification", "Disables the SSL hostname verification if set to true. Hostname verification is enabled by default.", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<Boolean> SSL_ALLOW_SELF_SIGNED_CERTIFICATES = new ConfigOption(SSL_NS, "allow-self-signed-certificates", "Controls the accepting of the self-signed SSL certificates.", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigNamespace SSL_TRUSTSTORE_NS = new ConfigNamespace(SSL_NS, "truststore", "Configuration options for SSL Truststore.");
    public static final ConfigOption<String> SSL_TRUSTSTORE_LOCATION = new ConfigOption(SSL_TRUSTSTORE_NS, "location", "Marks the location of the SSL Truststore.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigOption<String> SSL_TRUSTSTORE_PASSWORD = new ConfigOption(SSL_TRUSTSTORE_NS, "password", "The password to access SSL Truststore.", ConfigOption.Type.LOCAL, (Object)"", Objects::nonNull);
    public static final ConfigNamespace SSL_KEYSTORE_NS = new ConfigNamespace(SSL_NS, "keystore", "Configuration options for SSL Keystore.");
    public static final ConfigOption<String> SSL_KEYSTORE_LOCATION = new ConfigOption(SSL_KEYSTORE_NS, "location", "Marks the location of the SSL Keystore.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigOption<String> SSL_KEYSTORE_PASSWORD = new ConfigOption(SSL_KEYSTORE_NS, "storepassword", "The password to access SSL Keystore.", ConfigOption.Type.LOCAL, (Object)"", Objects::nonNull);
    public static final ConfigOption<String> SSL_KEY_PASSWORD = new ConfigOption(SSL_KEYSTORE_NS, "keypassword", "The password to access the key in the SSL Keystore. If the option is not present, the value of \"storepassword\" is used.", ConfigOption.Type.LOCAL, (Object)"", Objects::nonNull);
    public static final ConfigNamespace ES_HTTP_NS = new ConfigNamespace(ELASTICSEARCH_NS, "http", "Configuration options for HTTP(S) transport.");
    public static final ConfigNamespace ES_HTTP_AUTH_NS = new ConfigNamespace(ES_HTTP_NS, "auth", "Configuration options for HTTP(S) authentication.");
    public static final ConfigOption<String> ES_HTTP_AUTH_TYPE = new ConfigOption(ES_HTTP_AUTH_NS, "type", "Authentication type to be used for HTTP(S) access.", ConfigOption.Type.LOCAL, (Object)HttpAuthTypes.NONE.toString());
    public static final ConfigNamespace ES_HTTP_AUTH_BASIC_NS = new ConfigNamespace(ES_HTTP_AUTH_NS, "basic", "Configuration options for HTTP(S) Basic authentication.");
    public static final ConfigOption<String> ES_HTTP_AUTH_USERNAME = new ConfigOption(ES_HTTP_AUTH_BASIC_NS, "username", "Username for HTTP(S) authentication.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigOption<String> ES_HTTP_AUTH_PASSWORD = new ConfigOption(ES_HTTP_AUTH_BASIC_NS, "password", "Password for HTTP(S) authentication.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigOption<String> ES_HTTP_AUTH_REALM = new ConfigOption(ES_HTTP_AUTH_BASIC_NS, "realm", "Realm value for HTTP(S) authentication. If empty, any realm is accepted.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigNamespace ES_HTTP_AUTH_CUSTOM_NS = new ConfigNamespace(ES_HTTP_AUTH_NS, "custom", "Configuration options for custom HTTP(S) authenticator.");
    public static final ConfigOption<String> ES_HTTP_AUTHENTICATOR_CLASS = new ConfigOption(ES_HTTP_AUTH_CUSTOM_NS, "authenticator-class", "Authenticator fully qualified class name.", ConfigOption.Type.LOCAL, (Object)"");
    public static final ConfigOption<String[]> ES_HTTP_AUTHENTICATOR_ARGS = new ConfigOption(ES_HTTP_AUTH_CUSTOM_NS, "authenticator-args", "Comma-separated custom authenticator constructor arguments.", ConfigOption.Type.LOCAL, (Object)new String[0]);
    public static final ConfigOption<Boolean> SETUP_MAX_OPEN_SCROLL_CONTEXTS = new ConfigOption(ELASTICSEARCH_NS, "setup-max-open-scroll-contexts", "Whether JanusGraph should setup max_open_scroll_context to maximum value for the cluster or not.", ConfigOption.Type.MASKABLE, (Object)true);
    public static final ConfigOption<Boolean> USE_MAPPING_FOR_ES7 = new ConfigOption(ELASTICSEARCH_NS, "use-mapping-for-es7", "Mapping types are deprecated in ElasticSearch 7 and JanusGraph will not use mapping types by default for ElasticSearch 7 but if you want to preserve mapping types, you can setup this parameter to true. If you are updating ElasticSearch from 6 to 7 and you don't want to reindex your indexes, you may setup this parameter to true but we do recommend to reindex your indexes and don't use this parameter.", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<Integer> RETRY_ON_CONFLICT = new ConfigOption(ELASTICSEARCH_NS, "retry_on_conflict", "Specify how many times should the operation be retried when a conflict occurs.", ConfigOption.Type.MASKABLE, (Object)0);
    public static final int HOST_PORT_DEFAULT = 9200;
    public static final int DEFAULT_GEO_MAX_LEVELS = 20;
    public static final double DEFAULT_GEO_DIST_ERROR_PCT = 0.025;
    private static final String PARAMETERIZED_DELETION_SCRIPT = ElasticSearchIndex.parameterizedScriptPrepare("", "for (field in params.fields) {", "    if (field.cardinality == 'SINGLE') {", "        ctx._source.remove(field.name);", "    } else if (ctx._source.containsKey(field.name)) {", "        def fieldIndex = ctx._source[field.name].indexOf(field.value);", "        if (fieldIndex >= 0 && fieldIndex < ctx._source[field.name].size()) {", "            ctx._source[field.name].remove(fieldIndex);", "        }", "    }", "}");
    private static final String PARAMETERIZED_ADDITION_SCRIPT = ElasticSearchIndex.parameterizedScriptPrepare("", "for (field in params.fields) {", "    if (ctx._source[field.name] == null) {", "        ctx._source[field.name] = [];", "    }", "    if (field.cardinality != 'SET' || ctx._source[field.name].indexOf(field.value) == -1) {", "        ctx._source[field.name].add(field.value);", "    }", "}");
    private static final String INDEX_NAME_SEPARATOR = "_";
    private static final String SCRIPT_ID_SEPARATOR = "-";
    private static final String MAX_OPEN_SCROLL_CONTEXT_PARAMETER = "search.max_open_scroll_context";
    private static final Map<String, Object> MAX_RESULT_WINDOW = ImmutableMap.of((Object)"index.max_result_window", (Object)Integer.MAX_VALUE);
    private static final Parameter[] NULL_PARAMETERS = null;
    private static final String TRACK_TOTAL_HITS_PARAMETER = "track_total_hits";
    private static final Parameter[] TRACK_TOTAL_HITS_DISABLED_PARAMETERS = new Parameter[]{new Parameter("track_total_hits", (Object)false)};
    private static final Map<String, Object> TRACK_TOTAL_HITS_DISABLED_REQUEST_BODY = ImmutableMap.of((Object)"track_total_hits", (Object)false);
    private static final Map<String, String> INDEX_STORE_NAMES_CACHE = new ConcurrentHashMap<String, String>();
    private static final int CACHE_LIMIT_TO_DISABLE = 50000;
    private static volatile boolean indexStoreNameCacheEnabled = true;
    private final AbstractESCompat compat;
    private final ElasticSearchClient client;
    private final String indexName;
    private final int batchSize;
    private final boolean useExternalMappings;
    private final boolean allowMappingUpdate;
    private final Map<String, Object> indexSetting;
    private final long createSleep;
    private final boolean useAllField;
    private final Map<String, Object> ingestPipelines;
    private final boolean useMappingForES7;
    private final String parameterizedAdditionScriptId;
    private final String parameterizedDeletionScriptId;

    public ElasticSearchIndex(Configuration config) throws BackendException {
        this.indexName = (String)config.get(GraphDatabaseConfiguration.INDEX_NAME, new String[0]);
        this.parameterizedAdditionScriptId = this.generateScriptId("add");
        this.parameterizedDeletionScriptId = this.generateScriptId("del");
        this.useAllField = (Boolean)config.get(USE_ALL_FIELD, new String[0]);
        this.useExternalMappings = (Boolean)config.get(USE_EXTERNAL_MAPPINGS, new String[0]);
        this.allowMappingUpdate = (Boolean)config.get(ALLOW_MAPPING_UPDATE, new String[0]);
        this.createSleep = (Long)config.get(CREATE_SLEEP, new String[0]);
        this.ingestPipelines = config.getSubset(ES_INGEST_PIPELINES, new String[0]);
        this.useMappingForES7 = (Boolean)config.get(USE_MAPPING_FOR_ES7, new String[0]);
        this.batchSize = (Integer)config.get(GraphDatabaseConfiguration.INDEX_MAX_RESULT_SET_SIZE, new String[0]);
        log.debug("Configured ES query nb result by query to {}", (Object)this.batchSize);
        this.client = this.interfaceConfiguration(config).getClient();
        this.checkClusterHealth((String)config.get(HEALTH_REQUEST_TIMEOUT, new String[0]));
        this.compat = ESCompatUtils.acquireCompatForVersion(this.client.getMajorVersion());
        this.indexSetting = ElasticSearchSetup.getSettingsFromJanusGraphConf(config);
        this.setupMaxOpenScrollContextsIfNeeded(config);
        this.setupStoredScripts();
    }

    private void checkClusterHealth(String healthCheck) throws BackendException {
        try {
            this.client.clusterHealthRequest(healthCheck);
        }
        catch (IOException e) {
            throw new PermanentBackendException(e.getMessage(), (Throwable)e);
        }
    }

    private void setupStoredScripts() throws PermanentBackendException {
        this.setupStoredScriptIfNeeded(this.parameterizedAdditionScriptId, PARAMETERIZED_ADDITION_SCRIPT);
        this.setupStoredScriptIfNeeded(this.parameterizedDeletionScriptId, PARAMETERIZED_DELETION_SCRIPT);
    }

    private void setupStoredScriptIfNeeded(String storedScriptId, String source) throws PermanentBackendException {
        ImmutableMap preparedScript = this.compat.prepareScript(source).build();
        String lang = (String)((ImmutableMap)preparedScript.get((Object)"script")).get((Object)"lang");
        try {
            ESScriptResponse esScriptResponse = this.client.getStoredScript(storedScriptId);
            if (Boolean.FALSE.equals(esScriptResponse.getFound()) || !Objects.equals(lang, esScriptResponse.getScript().getLang()) || !Objects.equals(source, esScriptResponse.getScript().getSource())) {
                this.client.createStoredScript(storedScriptId, (Map<String, Object>)preparedScript);
            }
        }
        catch (IOException e) {
            throw new PermanentBackendException(e.getMessage(), (Throwable)e);
        }
    }

    private void setupMaxOpenScrollContextsIfNeeded(Configuration config) throws PermanentBackendException {
        boolean setupMaxOpenScrollContexts;
        if (this.client.getMajorVersion().getValue() > 6 && (setupMaxOpenScrollContexts = config.has(SETUP_MAX_OPEN_SCROLL_CONTEXTS, new String[0]) ? ((Boolean)config.get(SETUP_MAX_OPEN_SCROLL_CONTEXTS, new String[0])).booleanValue() : ((Boolean)SETUP_MAX_OPEN_SCROLL_CONTEXTS.getDefaultValue()).booleanValue())) {
            ImmutableMap settings = ImmutableMap.of((Object)"persistent", (Object)ImmutableMap.of((Object)MAX_OPEN_SCROLL_CONTEXT_PARAMETER, (Object)Integer.MAX_VALUE));
            try {
                this.client.updateClusterSettings((Map<String, Object>)settings);
            }
            catch (IOException e) {
                throw new PermanentBackendException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void checkForOrCreateIndex(String index) throws IOException {
        Objects.requireNonNull(this.client);
        Objects.requireNonNull(index);
        if (!this.useExternalMappings && !this.client.indexExists(index)) {
            this.client.createIndex(index, this.indexSetting);
            this.client.updateIndexSettings(index, MAX_RESULT_WINDOW);
            try {
                log.debug("Sleeping {} ms after {} index creation returned from actionGet()", (Object)this.createSleep, (Object)index);
                Thread.sleep(this.createSleep);
            }
            catch (InterruptedException e) {
                throw new JanusGraphException("Interrupted while waiting for index to settle in", (Throwable)e);
            }
        }
        Preconditions.checkState((boolean)this.client.indexExists(index), (String)"Could not create index: %s", (Object[])new Object[]{index});
        this.client.addAlias(this.indexName, index);
    }

    private ElasticSearchSetup.Connection interfaceConfiguration(Configuration config) {
        ElasticSearchSetup clientMode = (ElasticSearchSetup)ConfigOption.getEnumValue((String)((String)config.get(INTERFACE, new String[0])), ElasticSearchSetup.class);
        try {
            return clientMode.connect(config);
        }
        catch (IOException e) {
            throw new JanusGraphException((Throwable)e);
        }
    }

    private BackendException convert(Exception esException) {
        if (esException instanceof InterruptedException) {
            return new TemporaryBackendException("Interrupted while waiting for response", (Throwable)esException);
        }
        return new PermanentBackendException("Unknown exception while executing index operation", (Throwable)esException);
    }

    private static String getDualMappingName(String key) {
        return key + STRING_MAPPING_SUFFIX;
    }

    private String generateScriptId(String uniqueScriptSuffix) {
        return this.indexName + SCRIPT_ID_SEPARATOR + uniqueScriptSuffix;
    }

    private String generateIndexStoreName(String store) {
        return this.indexName + INDEX_NAME_SEPARATOR + store.toLowerCase();
    }

    private String getIndexStoreName(String store) {
        if (indexStoreNameCacheEnabled) {
            String cachedName = INDEX_STORE_NAMES_CACHE.get(store);
            if (cachedName != null) {
                return cachedName;
            }
            cachedName = this.generateIndexStoreName(store);
            if (INDEX_STORE_NAMES_CACHE.size() < 50000) {
                INDEX_STORE_NAMES_CACHE.put(store, cachedName);
            } else {
                indexStoreNameCacheEnabled = false;
                INDEX_STORE_NAMES_CACHE.clear();
            }
            return cachedName;
        }
        return this.generateIndexStoreName(store);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws BackendException {
        Class dataType = information.getDataType();
        Mapping map = Mapping.getMapping((KeyInformation)information);
        Preconditions.checkArgument((map == Mapping.DEFAULT || AttributeUtils.isString((Class)dataType) || map == Mapping.PREFIX_TREE && AttributeUtils.isGeo((Class)dataType) ? 1 : 0) != 0, (String)"Specified illegal mapping [%s] for data type [%s]", (Object[])new Object[]{map, dataType});
        String indexStoreName = this.getIndexStoreName(store);
        if (this.useExternalMappings) {
            try {
                IndexMapping mappings = this.client.getMapping(indexStoreName, store);
                if (mappings == null || !mappings.isDynamic() && !mappings.getProperties().containsKey(key)) {
                    throw new PermanentBackendException("The external mapping for index '" + indexStoreName + "' and type '" + store + "' do not have property '" + key + "'");
                }
                if (!this.allowMappingUpdate || !mappings.isDynamic()) return;
                this.pushMapping(store, key, information);
                return;
            }
            catch (IOException e) {
                throw new PermanentBackendException((Throwable)e);
            }
        }
        try {
            this.checkForOrCreateIndex(indexStoreName);
        }
        catch (IOException e) {
            throw new PermanentBackendException((Throwable)e);
        }
        this.pushMapping(store, key, information);
    }

    private void pushMapping(String store, String key, KeyInformation information) throws AssertionError, BackendException {
        Object mapping;
        Class dataType = information.getDataType();
        Mapping map = Mapping.getMapping((KeyInformation)information);
        HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
        if (AttributeUtils.isString((Class)dataType)) {
            if (map == Mapping.DEFAULT) {
                map = Mapping.TEXT;
            }
            log.debug("Registering string type for {} with mapping {}", (Object)key, (Object)map);
            String stringAnalyzer = (String)ParameterType.STRING_ANALYZER.findParameter(information.getParameters(), null);
            String textAnalyzer = (String)ParameterType.TEXT_ANALYZER.findParameter(information.getParameters(), null);
            Map<String, Object> stringMapping = stringAnalyzer == null ? this.compat.createKeywordMapping() : this.compat.createTextMapping(stringAnalyzer);
            switch (map) {
                case STRING: {
                    properties.put(key, stringMapping);
                    break;
                }
                case TEXT: {
                    properties.put(key, this.compat.createTextMapping(textAnalyzer));
                    break;
                }
                case TEXTSTRING: {
                    properties.put(key, this.compat.createTextMapping(textAnalyzer));
                    properties.put(ElasticSearchIndex.getDualMappingName(key), stringMapping);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected mapping: " + map));
                }
            }
        } else if (dataType == Float.class) {
            log.debug("Registering float type for {}", (Object)key);
            properties.put(key, (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"float"));
        } else if (dataType == Double.class) {
            log.debug("Registering double type for {}", (Object)key);
            properties.put(key, (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"double"));
        } else if (dataType == Byte.class) {
            log.debug("Registering byte type for {}", (Object)key);
            properties.put(key, (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"byte"));
        } else if (dataType == Short.class) {
            log.debug("Registering short type for {}", (Object)key);
            properties.put(key, (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"short"));
        } else if (dataType == Integer.class) {
            log.debug("Registering integer type for {}", (Object)key);
            properties.put(key, (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"integer"));
        } else if (dataType == Long.class) {
            log.debug("Registering long type for {}", (Object)key);
            properties.put(key, (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"long"));
        } else if (dataType == Boolean.class) {
            log.debug("Registering boolean type for {}", (Object)key);
            properties.put(key, (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"boolean"));
        } else if (dataType == Geoshape.class) {
            switch (map) {
                case PREFIX_TREE: {
                    int maxLevels = (Integer)ParameterType.INDEX_GEO_MAX_LEVELS.findParameter(information.getParameters(), (Object)20);
                    double distErrorPct = (Double)ParameterType.INDEX_GEO_DIST_ERROR_PCT.findParameter(information.getParameters(), (Object)0.025);
                    log.debug("Registering geo_shape type for {} with tree_levels={} and distance_error_pct={}", new Object[]{key, maxLevels, distErrorPct});
                    properties.put(key, (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"geo_shape", (Object)"tree", (Object)"quadtree", (Object)"tree_levels", (Object)maxLevels, (Object)"distance_error_pct", (Object)distErrorPct));
                    break;
                }
                default: {
                    log.debug("Registering geo_point type for {}", (Object)key);
                    properties.put(key, (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"geo_point"));
                    break;
                }
            }
        } else if (dataType == Date.class || dataType == Instant.class) {
            log.debug("Registering date type for {}", (Object)key);
            properties.put(key, (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)"date"));
        } else if (dataType == UUID.class) {
            log.debug("Registering uuid type for {}", (Object)key);
            properties.put(key, this.compat.createKeywordMapping());
        }
        if (this.useAllField) {
            properties.put("all", this.compat.createTextMapping(null));
            if (properties.containsKey(key) && dataType != Geoshape.class) {
                HashMap<String, String> mapping2 = new HashMap<String, String>((Map)properties.get(key));
                mapping2.put("copy_to", "all");
                properties.put(key, mapping2);
            }
        }
        List customParameters = ParameterType.getCustomParameters((Parameter[])information.getParameters());
        if (properties.containsKey(key) && !customParameters.isEmpty()) {
            mapping = new HashMap((Map)properties.get(key));
            customParameters.forEach(arg_0 -> ElasticSearchIndex.lambda$pushMapping$0((Map)mapping, arg_0));
            properties.put(key, (Map<String, Object>)mapping);
        }
        mapping = ImmutableMap.of((Object)"properties", properties);
        try {
            this.client.createMapping(this.getIndexStoreName(store), store, (Map<String, Object>)mapping);
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    private static Mapping getStringMapping(KeyInformation information) {
        assert (AttributeUtils.isString((Class)information.getDataType()));
        Mapping map = Mapping.getMapping((KeyInformation)information);
        if (map == Mapping.DEFAULT) {
            map = Mapping.TEXT;
        }
        return map;
    }

    private static boolean hasDualStringMapping(KeyInformation information) {
        return AttributeUtils.isString((Class)information.getDataType()) && ElasticSearchIndex.getStringMapping(information) == Mapping.TEXTSTRING;
    }

    public Map<String, Object> getNewDocument(List<IndexEntry> additions, KeyInformation.StoreRetriever information) throws BackendException {
        LinkedListMultimap unique = LinkedListMultimap.create();
        for (IndexEntry e : additions) {
            unique.put((Object)e.field, (Object)e);
        }
        HashMap<String, Object> doc = new HashMap<String, Object>();
        for (Map.Entry add : unique.asMap().entrySet()) {
            Object[] value;
            KeyInformation keyInformation = information.get((String)add.getKey());
            switch (keyInformation.getCardinality()) {
                case SINGLE: {
                    value = ElasticSearchIndex.convertToEsType(((IndexEntry)Iterators.getLast(((Collection)add.getValue()).iterator())).value, Mapping.getMapping((KeyInformation)keyInformation));
                    break;
                }
                case SET: 
                case LIST: {
                    value = ((Collection)add.getValue()).stream().map(v -> ElasticSearchIndex.convertToEsType(v.value, Mapping.getMapping((KeyInformation)keyInformation))).filter(v -> {
                        Preconditions.checkArgument((!(v instanceof byte[]) ? 1 : 0) != 0, (Object)("Collections not supported for " + (String)add.getKey()));
                        return true;
                    }).toArray();
                    break;
                }
                default: {
                    value = null;
                }
            }
            doc.put((String)add.getKey(), value);
            if (!ElasticSearchIndex.hasDualStringMapping(information.get((String)add.getKey())) || keyInformation.getDataType() != String.class) continue;
            doc.put(ElasticSearchIndex.getDualMappingName((String)add.getKey()), value);
        }
        return doc;
    }

    private static Object convertToEsType(Object value, Mapping mapping) {
        if (value instanceof Number) {
            if (AttributeUtils.isWholeNumber((Number)((Number)value))) {
                return ((Number)value).longValue();
            }
            return ((Number)value).doubleValue();
        }
        if (AttributeUtils.isString((Object)value)) {
            return value;
        }
        if (value instanceof Geoshape) {
            return ElasticSearchIndex.convertGeoshape((Geoshape)value, mapping);
        }
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof Instant) {
            return Date.from((Instant)value);
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        throw new IllegalArgumentException("Unsupported type: " + value.getClass() + " (value: " + value + ")");
    }

    private static Object convertGeoshape(Geoshape geoshape, Mapping mapping) {
        if (geoshape.getType() == Geoshape.Type.POINT && Mapping.PREFIX_TREE != mapping) {
            Geoshape.Point p = geoshape.getPoint();
            return new double[]{p.getLongitude(), p.getLatitude()};
        }
        if (geoshape.getType() == Geoshape.Type.BOX) {
            Rectangle box = geoshape.getShape().getBoundingBox();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", "envelope");
            map.put("coordinates", new double[][]{{box.getMinX(), box.getMaxY()}, {box.getMaxX(), box.getMinY()}});
            return map;
        }
        if (geoshape.getType() == Geoshape.Type.CIRCLE) {
            try {
                Map map = geoshape.toMap();
                map.put("radius", map.get("radius") + (String)((Map)map.remove("properties")).get("radius_units"));
                return map;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid geoshape: " + geoshape, e);
            }
        }
        try {
            return geoshape.toMap();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid geoshape: " + geoshape, e);
        }
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        ArrayList<ElasticSearchMutation> requests = new ArrayList<ElasticSearchMutation>();
        try {
            for (Map.Entry<String, Map<String, IndexMutation>> stores : mutations.entrySet()) {
                ArrayList<ElasticSearchMutation> requestByStore = new ArrayList<ElasticSearchMutation>();
                String storeName = stores.getKey();
                String indexStoreName = this.getIndexStoreName(storeName);
                for (Map.Entry<String, IndexMutation> entry : stores.getValue().entrySet()) {
                    Map<String, Object> doc;
                    String documentId = entry.getKey();
                    IndexMutation mutation = entry.getValue();
                    assert (mutation.isConsolidated());
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.isDeleted() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.hasDeletions() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isDeleted() || !mutation.hasAdditions() ? 1 : 0) != 0);
                    if (mutation.hasDeletions()) {
                        if (mutation.isDeleted()) {
                            log.trace("Deleting entire document {}", (Object)documentId);
                            requestByStore.add(ElasticSearchMutation.createDeleteRequest(indexStoreName, storeName, documentId));
                        } else {
                            List<Map<String, Object>> params = this.getParameters(information.get(storeName), mutation.getDeletions(), true, new Cardinality[0]);
                            ImmutableMap doc2 = this.compat.prepareStoredScript(this.parameterizedDeletionScriptId, params).build();
                            log.trace("Deletion script {} with params {}", (Object)PARAMETERIZED_DELETION_SCRIPT, params);
                            requestByStore.add(ElasticSearchMutation.createUpdateRequest(indexStoreName, storeName, documentId, (Map)doc2));
                        }
                    }
                    if (!mutation.hasAdditions()) continue;
                    if (mutation.isNew()) {
                        log.trace("Adding entire document {}", (Object)documentId);
                        Map<String, Object> source = this.getNewDocument(mutation.getAdditions(), information.get(storeName));
                        requestByStore.add(ElasticSearchMutation.createIndexRequest(indexStoreName, storeName, documentId, source));
                        continue;
                    }
                    Map<String, Object> upsert = !mutation.hasDeletions() ? this.getNewDocument(mutation.getAdditions(), information.get(storeName)) : null;
                    List<Map<String, Object>> params = this.getParameters(information.get(storeName), mutation.getAdditions(), false, Cardinality.SINGLE);
                    if (!params.isEmpty()) {
                        ImmutableMap.Builder<String, Object> builder = this.compat.prepareStoredScript(this.parameterizedAdditionScriptId, params);
                        requestByStore.add(ElasticSearchMutation.createUpdateRequest(indexStoreName, storeName, documentId, builder, upsert));
                        log.trace("Adding script {} with params {}", (Object)PARAMETERIZED_ADDITION_SCRIPT, params);
                    }
                    if ((doc = this.getAdditionDoc(information, storeName, mutation)).isEmpty()) continue;
                    ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"doc", doc);
                    requestByStore.add(ElasticSearchMutation.createUpdateRequest(indexStoreName, storeName, documentId, builder, upsert));
                    log.trace("Adding update {}", doc);
                }
                if (!requestByStore.isEmpty() && this.ingestPipelines.containsKey(storeName)) {
                    this.client.bulkRequest(requestByStore, String.valueOf(this.ingestPipelines.get(storeName)));
                    continue;
                }
                if (requestByStore.isEmpty()) continue;
                requests.addAll(requestByStore);
            }
            if (!requests.isEmpty()) {
                this.client.bulkRequest(requests, null);
            }
        }
        catch (Exception e) {
            log.error("Failed to execute bulk Elasticsearch mutation", (Throwable)e);
            throw this.convert(e);
        }
    }

    private List<Map<String, Object>> getParameters(KeyInformation.StoreRetriever storeRetriever, List<IndexEntry> entries, boolean deletion, Cardinality ... cardinalitiesToSkip) {
        HashSet cardinalityToSkipSet = Sets.newHashSet((Object[])cardinalitiesToSkip);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (IndexEntry entry : entries) {
            KeyInformation info = storeRetriever.get(entry.field);
            if (cardinalityToSkipSet.contains(info.getCardinality())) continue;
            Object jsValue = deletion && info.getCardinality() == Cardinality.SINGLE ? "" : ElasticSearchIndex.convertToEsType(entry.value, Mapping.getMapping((KeyInformation)info));
            result.add((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)entry.field, (Object)"value", (Object)jsValue, (Object)"cardinality", (Object)info.getCardinality().name()));
            if (!ElasticSearchIndex.hasDualStringMapping(info)) continue;
            result.add((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)ElasticSearchIndex.getDualMappingName(entry.field), (Object)"value", (Object)jsValue, (Object)"cardinality", (Object)info.getCardinality().name()));
        }
        return result;
    }

    private Map<String, Object> getAdditionDoc(KeyInformation.IndexRetriever information, String store, IndexMutation mutation) throws PermanentBackendException {
        HashMap<String, Object> doc = new HashMap<String, Object>();
        for (IndexEntry e : mutation.getAdditions()) {
            KeyInformation keyInformation = information.get(store).get(e.field);
            if (keyInformation.getCardinality() != Cardinality.SINGLE) continue;
            doc.put(e.field, ElasticSearchIndex.convertToEsType(e.value, Mapping.getMapping((KeyInformation)keyInformation)));
            if (!ElasticSearchIndex.hasDualStringMapping(keyInformation)) continue;
            doc.put(ElasticSearchIndex.getDualMappingName(e.field), ElasticSearchIndex.convertToEsType(e.value, Mapping.getMapping((KeyInformation)keyInformation)));
        }
        return doc;
    }

    public void restore(Map<String, Map<String, List<IndexEntry>>> documents, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        ArrayList<ElasticSearchMutation> requests = new ArrayList<ElasticSearchMutation>();
        try {
            for (Map.Entry<String, Map<String, List<IndexEntry>>> stores : documents.entrySet()) {
                ArrayList<ElasticSearchMutation> requestByStore = new ArrayList<ElasticSearchMutation>();
                String store = stores.getKey();
                String indexStoreName = this.getIndexStoreName(store);
                for (Map.Entry<String, List<IndexEntry>> entry : stores.getValue().entrySet()) {
                    String docID = entry.getKey();
                    List<IndexEntry> content = entry.getValue();
                    if (content == null || content.size() == 0) {
                        if (log.isTraceEnabled()) {
                            log.trace("Deleting entire document {}", (Object)docID);
                        }
                        requestByStore.add(ElasticSearchMutation.createDeleteRequest(indexStoreName, store, docID));
                        continue;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("Adding entire document {}", (Object)docID);
                    }
                    Map<String, Object> source = this.getNewDocument(content, information.get(store));
                    requestByStore.add(ElasticSearchMutation.createIndexRequest(indexStoreName, store, docID, source));
                }
                if (!requestByStore.isEmpty() && this.ingestPipelines.containsKey(store)) {
                    this.client.bulkRequest(requestByStore, String.valueOf(this.ingestPipelines.get(store)));
                    continue;
                }
                if (requestByStore.isEmpty()) continue;
                requests.addAll(requestByStore);
            }
            if (!requests.isEmpty()) {
                this.client.bulkRequest(requests, null);
            }
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    private Map<String, Object> getRelationFromCmp(Cmp cmp, String key, Object value) {
        switch (cmp) {
            case EQUAL: {
                return this.compat.term(key, value);
            }
            case NOT_EQUAL: {
                return this.compat.boolMustNot(this.compat.term(key, value));
            }
            case LESS_THAN: {
                return this.compat.lt(key, value);
            }
            case LESS_THAN_EQUAL: {
                return this.compat.lte(key, value);
            }
            case GREATER_THAN: {
                return this.compat.gt(key, value);
            }
            case GREATER_THAN_EQUAL: {
                return this.compat.gte(key, value);
            }
        }
        throw new IllegalArgumentException("Unexpected relation: " + cmp);
    }

    public Map<String, Object> getFilter(Condition<?> condition, KeyInformation.StoreRetriever information) {
        if (condition instanceof PredicateCondition) {
            PredicateCondition atom = (PredicateCondition)condition;
            Object value = atom.getValue();
            String key = (String)atom.getKey();
            JanusGraphPredicate predicate = atom.getPredicate();
            if (value instanceof Number) {
                Preconditions.checkArgument((boolean)(predicate instanceof Cmp), (Object)("Relation not supported on numeric types: " + predicate));
                return this.getRelationFromCmp((Cmp)predicate, key, value);
            }
            if (value instanceof String) {
                Mapping mapping = ElasticSearchIndex.getStringMapping(information.get(key));
                if (mapping == Mapping.TEXT && !Text.HAS_CONTAINS.contains(predicate) && !(predicate instanceof Cmp)) {
                    throw new IllegalArgumentException("Text mapped string values only support CONTAINS and Compare queries and not: " + predicate);
                }
                if (mapping == Mapping.STRING && Text.HAS_CONTAINS.contains(predicate)) {
                    throw new IllegalArgumentException("String mapped string values do not support CONTAINS queries: " + predicate);
                }
                String fieldName = mapping == Mapping.TEXTSTRING && !Text.HAS_CONTAINS.contains(predicate) && (!(predicate instanceof Cmp) || predicate == Cmp.EQUAL) ? ElasticSearchIndex.getDualMappingName(key) : key;
                if (predicate == Text.CONTAINS || predicate == Cmp.EQUAL) {
                    return this.compat.match(fieldName, value);
                }
                if (predicate == Text.CONTAINS_PREFIX) {
                    if (!ParameterType.TEXT_ANALYZER.hasParameter(information.get(key).getParameters())) {
                        value = ((String)value).toLowerCase();
                    }
                    return this.compat.prefix(fieldName, value);
                }
                if (predicate == Text.CONTAINS_REGEX) {
                    if (!ParameterType.TEXT_ANALYZER.hasParameter(information.get(key).getParameters())) {
                        value = ((String)value).toLowerCase();
                    }
                    return this.compat.regexp(fieldName, value);
                }
                if (predicate == Text.PREFIX) {
                    return this.compat.prefix(fieldName, value);
                }
                if (predicate == Text.REGEX) {
                    return this.compat.regexp(fieldName, value);
                }
                if (predicate == Cmp.NOT_EQUAL) {
                    return this.compat.boolMustNot(this.compat.match(fieldName, value));
                }
                if (predicate == Text.FUZZY || predicate == Text.CONTAINS_FUZZY) {
                    return this.compat.fuzzyMatch(fieldName, value);
                }
                if (predicate == Cmp.LESS_THAN) {
                    return this.compat.lt(fieldName, value);
                }
                if (predicate == Cmp.LESS_THAN_EQUAL) {
                    return this.compat.lte(fieldName, value);
                }
                if (predicate == Cmp.GREATER_THAN) {
                    return this.compat.gt(fieldName, value);
                }
                if (predicate == Cmp.GREATER_THAN_EQUAL) {
                    return this.compat.gte(fieldName, value);
                }
                throw new IllegalArgumentException("Predicate is not supported for string value: " + predicate);
            }
            if (value instanceof Geoshape && Mapping.getMapping((KeyInformation)information.get(key)) == Mapping.DEFAULT) {
                Map<String, Object> query;
                Geoshape shape = (Geoshape)value;
                Preconditions.checkArgument((predicate instanceof Geo && predicate != Geo.CONTAINS ? 1 : 0) != 0, (Object)("Relation not supported on geopoint types: " + predicate));
                switch (shape.getType()) {
                    case CIRCLE: {
                        Geoshape.Point center = shape.getPoint();
                        query = this.compat.geoDistance(key, center.getLatitude(), center.getLongitude(), shape.getRadius());
                        break;
                    }
                    case BOX: {
                        Geoshape.Point southwest = shape.getPoint(0);
                        Geoshape.Point northeast = shape.getPoint(1);
                        query = this.compat.geoBoundingBox(key, southwest.getLatitude(), southwest.getLongitude(), northeast.getLatitude(), northeast.getLongitude());
                        break;
                    }
                    case POLYGON: {
                        List<List<Double>> points = IntStream.range(0, shape.size()).mapToObj(i -> ImmutableList.of((Object)shape.getPoint(i).getLongitude(), (Object)shape.getPoint(i).getLatitude())).collect(Collectors.toList());
                        query = this.compat.geoPolygon(key, points);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported or invalid search shape type for geopoint: " + shape.getType());
                    }
                }
                return predicate == Geo.DISJOINT ? this.compat.boolMustNot(query) : query;
            }
            if (value instanceof Geoshape) {
                ImmutableMap geo;
                Preconditions.checkArgument((boolean)(predicate instanceof Geo), (Object)("Relation not supported on geoshape types: " + predicate));
                Geoshape shape = (Geoshape)value;
                switch (shape.getType()) {
                    case CIRCLE: {
                        Geoshape.Point center = shape.getPoint();
                        geo = ImmutableMap.of((Object)"type", (Object)"circle", (Object)"coordinates", (Object)ImmutableList.of((Object)center.getLongitude(), (Object)center.getLatitude()), (Object)"radius", (Object)(shape.getRadius() + "km"));
                        break;
                    }
                    case BOX: {
                        Geoshape.Point southwest = shape.getPoint(0);
                        Geoshape.Point northeast = shape.getPoint(1);
                        geo = ImmutableMap.of((Object)"type", (Object)"envelope", (Object)"coordinates", (Object)ImmutableList.of((Object)ImmutableList.of((Object)southwest.getLongitude(), (Object)northeast.getLatitude()), (Object)ImmutableList.of((Object)northeast.getLongitude(), (Object)southwest.getLatitude())));
                        break;
                    }
                    case LINE: {
                        List lineCoords = IntStream.range(0, shape.size()).mapToObj(i -> ImmutableList.of((Object)shape.getPoint(i).getLongitude(), (Object)shape.getPoint(i).getLatitude())).collect(Collectors.toList());
                        geo = ImmutableMap.of((Object)"type", (Object)"linestring", (Object)"coordinates", lineCoords);
                        break;
                    }
                    case POLYGON: {
                        List polyCoords = IntStream.range(0, shape.size()).mapToObj(i -> ImmutableList.of((Object)shape.getPoint(i).getLongitude(), (Object)shape.getPoint(i).getLatitude())).collect(Collectors.toList());
                        geo = ImmutableMap.of((Object)"type", (Object)"polygon", (Object)"coordinates", (Object)ImmutableList.of(polyCoords));
                        break;
                    }
                    case POINT: {
                        geo = ImmutableMap.of((Object)"type", (Object)"point", (Object)"coordinates", (Object)ImmutableList.of((Object)shape.getPoint().getLongitude(), (Object)shape.getPoint().getLatitude()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported or invalid search shape type: " + shape.getType());
                    }
                }
                return this.compat.geoShape(key, (Map<String, Object>)geo, (Geo)predicate);
            }
            if (value instanceof Date || value instanceof Instant) {
                Preconditions.checkArgument((boolean)(predicate instanceof Cmp), (Object)("Relation not supported on date types: " + predicate));
                if (value instanceof Instant) {
                    value = Date.from((Instant)value);
                }
                return this.getRelationFromCmp((Cmp)predicate, key, value);
            }
            if (value instanceof Boolean) {
                Cmp numRel = (Cmp)predicate;
                switch (numRel) {
                    case EQUAL: {
                        return this.compat.term(key, value);
                    }
                    case NOT_EQUAL: {
                        return this.compat.boolMustNot(this.compat.term(key, value));
                    }
                }
                throw new IllegalArgumentException("Boolean types only support EQUAL or NOT_EQUAL");
            }
            if (value instanceof UUID) {
                if (predicate == Cmp.EQUAL) {
                    return this.compat.term(key, value);
                }
                if (predicate == Cmp.NOT_EQUAL) {
                    return this.compat.boolMustNot(this.compat.term(key, value));
                }
                throw new IllegalArgumentException("Only equal or not equal is supported for UUIDs: " + predicate);
            }
            throw new IllegalArgumentException("Unsupported type: " + value);
        }
        if (condition instanceof Not) {
            return this.compat.boolMustNot(this.getFilter(((Not)condition).getChild(), information));
        }
        if (condition instanceof And) {
            List<Map<String, Object>> queries = StreamSupport.stream(condition.getChildren().spliterator(), false).map(c -> this.getFilter((Condition<?>)c, information)).collect(Collectors.toList());
            return this.compat.boolMust(queries);
        }
        if (condition instanceof Or) {
            List<Map<String, Object>> queries = StreamSupport.stream(condition.getChildren().spliterator(), false).map(c -> this.getFilter((Condition<?>)c, information)).collect(Collectors.toList());
            return this.compat.boolShould(queries);
        }
        throw new IllegalArgumentException("Invalid condition: " + condition);
    }

    public Stream<String> query(IndexQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        ElasticSearchRequest sr = new ElasticSearchRequest();
        Map<String, Object> esQuery = this.getFilter(query.getCondition(), informations.get(query.getStore()));
        sr.setQuery(this.compat.prepareQuery(esQuery));
        if (!query.getOrder().isEmpty()) {
            this.addOrderToQuery(informations, sr, query.getOrder(), query.getStore());
        }
        sr.setFrom(0);
        if (query.hasLimit()) {
            sr.setSize(Math.min(query.getLimit(), this.batchSize));
        } else {
            sr.setSize(this.batchSize);
        }
        sr.setDisableSourceRetrieval(true);
        try {
            String indexStoreName = this.getIndexStoreName(query.getStore());
            boolean useScroll = sr.getSize() >= this.batchSize;
            ElasticSearchResponse response = this.client.search(indexStoreName, this.compat.createRequestBody(sr, useScroll ? NULL_PARAMETERS : TRACK_TOTAL_HITS_DISABLED_PARAMETERS), useScroll);
            log.debug("First Executed query [{}] in {} ms", (Object)query.getCondition(), (Object)response.getTook());
            Iterator<RawQuery.Result<String>> resultIterator = this.getResultsIterator(useScroll, response, sr.getSize());
            Stream<RawQuery.Result<String>> toReturn = StreamSupport.stream(Spliterators.spliteratorUnknownSize(resultIterator, 16), false);
            return (query.hasLimit() ? toReturn.limit(query.getLimit()) : toReturn).map(RawQuery.Result::getResult);
        }
        catch (IOException | UncheckedIOException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private Iterator<RawQuery.Result<String>> getResultsIterator(boolean useScroll, ElasticSearchResponse response, int windowSize) {
        return useScroll ? new ElasticSearchScroll(this.client, response, windowSize) : response.getResults().iterator();
    }

    private String convertToEsDataType(Class<?> dataType, Mapping mapping) {
        if (String.class.isAssignableFrom(dataType)) {
            return "string";
        }
        if (Integer.class.isAssignableFrom(dataType)) {
            return "integer";
        }
        if (Long.class.isAssignableFrom(dataType)) {
            return "long";
        }
        if (Float.class.isAssignableFrom(dataType)) {
            return "float";
        }
        if (Double.class.isAssignableFrom(dataType)) {
            return "double";
        }
        if (Boolean.class.isAssignableFrom(dataType)) {
            return "boolean";
        }
        if (Date.class.isAssignableFrom(dataType)) {
            return "date";
        }
        if (Instant.class.isAssignableFrom(dataType)) {
            return "date";
        }
        if (Geoshape.class.isAssignableFrom(dataType)) {
            return mapping == Mapping.DEFAULT ? "geo_point" : "geo_shape";
        }
        return null;
    }

    private ElasticSearchResponse runCommonQuery(RawQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx, int size, boolean useScroll) throws BackendException {
        ElasticSearchRequest sr = new ElasticSearchRequest();
        sr.setQuery(this.compat.queryString(query.getQuery()));
        if (!query.getOrders().isEmpty()) {
            this.addOrderToQuery(informations, sr, (List<IndexQuery.OrderEntry>)query.getOrders(), query.getStore());
        }
        sr.setFrom(0);
        sr.setSize(size);
        sr.setDisableSourceRetrieval(true);
        try {
            Map<String, Object> requestBody = this.compat.createRequestBody(sr, query.getParameters());
            if (!useScroll) {
                if (requestBody == null) {
                    requestBody = TRACK_TOTAL_HITS_DISABLED_REQUEST_BODY;
                } else {
                    requestBody.put(TRACK_TOTAL_HITS_PARAMETER, false);
                }
            }
            return this.client.search(this.getIndexStoreName(query.getStore()), requestBody, useScroll);
        }
        catch (IOException | UncheckedIOException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private long runCountQuery(RawQuery query) throws BackendException {
        try {
            return this.client.countTotal(this.getIndexStoreName(query.getStore()), this.compat.createRequestBody(this.compat.queryString(query.getQuery()), query.getParameters()));
        }
        catch (IOException | UncheckedIOException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private void addOrderToQuery(KeyInformation.IndexRetriever informations, ElasticSearchRequest sr, List<IndexQuery.OrderEntry> orders, String store) {
        for (IndexQuery.OrderEntry orderEntry : orders) {
            String order = orderEntry.getOrder().name();
            KeyInformation information = informations.get(store).get(orderEntry.getKey());
            Mapping mapping = Mapping.getMapping((KeyInformation)information);
            Class datatype = orderEntry.getDatatype();
            sr.addSort(orderEntry.getKey(), order.toLowerCase(), this.convertToEsDataType(datatype, mapping));
        }
    }

    public Stream<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        int size = query.hasLimit() ? Math.min(query.getLimit() + query.getOffset(), this.batchSize) : this.batchSize;
        boolean useScroll = size >= this.batchSize;
        ElasticSearchResponse response = this.runCommonQuery(query, information, tx, size, useScroll);
        log.debug("First Executed query [{}] in {} ms", (Object)query.getQuery(), (Object)response.getTook());
        Iterator<RawQuery.Result<String>> resultIterator = this.getResultsIterator(useScroll, response, size);
        Stream<RawQuery.Result<String>> toReturn = StreamSupport.stream(Spliterators.spliteratorUnknownSize(resultIterator, 16), false).skip(query.getOffset());
        return query.hasLimit() ? toReturn.limit(query.getLimit()) : toReturn;
    }

    public Long totals(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        long startTime = System.currentTimeMillis();
        long count = this.runCountQuery(query);
        if (log.isDebugEnabled()) {
            log.debug("Executed count query [{}] in {} ms", (Object)query.getQuery(), (Object)(System.currentTimeMillis() - startTime));
        }
        return count;
    }

    public boolean supports(KeyInformation information, JanusGraphPredicate janusgraphPredicate) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (!(mapping == Mapping.DEFAULT || AttributeUtils.isString((Class)dataType) || mapping == Mapping.PREFIX_TREE && AttributeUtils.isGeo((Class)dataType))) {
            return false;
        }
        if (Number.class.isAssignableFrom(dataType)) {
            return janusgraphPredicate instanceof Cmp;
        }
        if (dataType == Geoshape.class) {
            switch (mapping) {
                case DEFAULT: {
                    return janusgraphPredicate instanceof Geo && janusgraphPredicate != Geo.CONTAINS;
                }
                case PREFIX_TREE: {
                    return janusgraphPredicate instanceof Geo;
                }
            }
        } else if (AttributeUtils.isString((Class)dataType)) {
            switch (mapping) {
                case TEXT: 
                case DEFAULT: {
                    return janusgraphPredicate == Text.CONTAINS || janusgraphPredicate == Text.CONTAINS_PREFIX || janusgraphPredicate == Text.CONTAINS_REGEX || janusgraphPredicate == Text.CONTAINS_FUZZY;
                }
                case STRING: {
                    return janusgraphPredicate instanceof Cmp || janusgraphPredicate == Text.REGEX || janusgraphPredicate == Text.PREFIX || janusgraphPredicate == Text.FUZZY;
                }
                case TEXTSTRING: {
                    return janusgraphPredicate instanceof Text || janusgraphPredicate instanceof Cmp;
                }
            }
        } else {
            if (dataType == Date.class || dataType == Instant.class) {
                return janusgraphPredicate instanceof Cmp;
            }
            if (dataType == Boolean.class) {
                return janusgraphPredicate == Cmp.EQUAL || janusgraphPredicate == Cmp.NOT_EQUAL;
            }
            if (dataType == UUID.class) {
                return janusgraphPredicate == Cmp.EQUAL || janusgraphPredicate == Cmp.NOT_EQUAL;
            }
        }
        return false;
    }

    public boolean supports(KeyInformation information) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (Number.class.isAssignableFrom(dataType) || dataType == Date.class || dataType == Instant.class || dataType == Boolean.class || dataType == UUID.class) {
            return mapping == Mapping.DEFAULT;
        }
        if (AttributeUtils.isString((Class)dataType)) {
            return mapping == Mapping.DEFAULT || mapping == Mapping.STRING || mapping == Mapping.TEXT || mapping == Mapping.TEXTSTRING;
        }
        if (AttributeUtils.isGeo((Class)dataType)) {
            return mapping == Mapping.DEFAULT || mapping == Mapping.PREFIX_TREE;
        }
        return false;
    }

    public String mapKey2Field(String key, KeyInformation information) {
        IndexProvider.checkKeyValidity((String)key);
        return key.replace(' ', '\u2022');
    }

    public IndexFeatures getFeatures() {
        return this.compat.getIndexFeatures();
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) throws BackendException {
        return new DefaultTransaction(config);
    }

    public void close() throws BackendException {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public void clearStorage() throws BackendException {
        try {
            this.client.deleteIndex(this.indexName);
        }
        catch (Exception e) {
            throw new PermanentBackendException("Could not delete index " + this.indexName, (Throwable)e);
        }
        finally {
            this.close();
        }
    }

    public boolean exists() throws BackendException {
        try {
            return this.client.indexExists(this.indexName);
        }
        catch (IOException e) {
            throw new PermanentBackendException("Could not check if index " + this.indexName + " exists", (Throwable)e);
        }
    }

    ElasticMajorVersion getVersion() {
        return this.client.getMajorVersion();
    }

    boolean isUseMappingForES7() {
        return this.useMappingForES7;
    }

    private static String parameterizedScriptPrepare(String ... lines) {
        return Arrays.stream(lines).map(String::trim).collect(Collectors.joining(""));
    }

    private static /* synthetic */ void lambda$pushMapping$0(Map mapping, Parameter p) {
        mapping.put(p.key(), p.value());
    }
}

