/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.compat;

import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.es.ElasticMajorVersion;
import org.janusgraph.diskstorage.es.compat.AbstractESCompat;
import org.janusgraph.diskstorage.es.compat.ES6Compat;
import org.janusgraph.diskstorage.es.compat.ES7Compat;
import org.janusgraph.diskstorage.es.compat.ES8Compat;

public class ESCompatUtils {
    public static AbstractESCompat acquireCompatForVersion(ElasticMajorVersion elasticMajorVersion) throws BackendException {
        switch (elasticMajorVersion) {
            case SIX: {
                return new ES6Compat();
            }
            case SEVEN: {
                return new ES7Compat();
            }
            case EIGHT: {
                return new ES8Compat();
            }
        }
        throw new PermanentBackendException("Unsupported Elasticsearch version: " + (Object)((Object)elasticMajorVersion));
    }
}

