/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchIndex;
import org.janusgraph.diskstorage.es.rest.RestElasticSearchClient;
import org.janusgraph.diskstorage.es.rest.util.BasicAuthHttpClientConfigCallback;
import org.janusgraph.diskstorage.es.rest.util.ConnectionKeepAliveConfigCallback;
import org.janusgraph.diskstorage.es.rest.util.HttpAuthTypes;
import org.janusgraph.diskstorage.es.rest.util.RestClientAuthenticator;
import org.janusgraph.diskstorage.es.rest.util.SSLConfigurationCallback;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientSetup {
    private static final Logger log = LoggerFactory.getLogger(RestClientSetup.class);

    public ElasticSearchClient connect(Configuration config) throws IOException {
        log.debug("Configuring RestClient");
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
        int defaultPort = config.has(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) ? (Integer)config.get(GraphDatabaseConfiguration.INDEX_PORT, new String[0]) : 9200;
        String httpScheme = (Boolean)config.get(ElasticSearchIndex.SSL_ENABLED, new String[0]) != false ? "https" : "http";
        for (String host : (String[])config.get(GraphDatabaseConfiguration.INDEX_HOSTS, new String[0])) {
            String[] hostStringParts = host.split(":");
            String hostname = hostStringParts[0];
            int hostPort = defaultPort;
            if (hostStringParts.length == 2) {
                hostPort = Integer.parseInt(hostStringParts[1]);
            }
            log.debug("Configured remote host: {} : {}", (Object)hostname, (Object)hostPort);
            hosts.add(new HttpHost(hostname, hostPort, httpScheme));
        }
        RestClient rc = this.getRestClient(hosts.toArray(new HttpHost[hosts.size()]), config);
        int scrollKeepAlive = (Integer)config.get(ElasticSearchIndex.ES_SCROLL_KEEP_ALIVE, new String[0]);
        Preconditions.checkArgument((scrollKeepAlive >= 1 ? 1 : 0) != 0, (Object)"Scroll keep-alive should be greater than or equal to 1");
        boolean useMappingTypesForES7 = (Boolean)config.get(ElasticSearchIndex.USE_MAPPING_FOR_ES7, new String[0]);
        int retryLimit = (Integer)config.getOrDefault(ElasticSearchIndex.RETRY_LIMIT, new String[0]);
        long retryInitialWaitMs = (Long)config.getOrDefault(ElasticSearchIndex.RETRY_INITIAL_WAIT, new String[0]);
        long retryMaxWaitMs = (Long)config.getOrDefault(ElasticSearchIndex.RETRY_MAX_WAIT, new String[0]);
        Set<Integer> errorCodesToRetry = Arrays.stream((Object[])config.getOrDefault(ElasticSearchIndex.RETRY_ERROR_CODES, new String[0])).mapToInt(Integer::parseInt).boxed().collect(Collectors.toSet());
        int bulkChunkLimitBytes = (Integer)config.getOrDefault(ElasticSearchIndex.BULK_CHUNK_SIZE_LIMIT_BYTES, new String[0]);
        RestElasticSearchClient client = this.getElasticSearchClient(rc, scrollKeepAlive, useMappingTypesForES7, retryLimit, errorCodesToRetry, retryInitialWaitMs, retryMaxWaitMs, bulkChunkLimitBytes);
        if (config.has(ElasticSearchIndex.BULK_REFRESH, new String[0])) {
            client.setBulkRefresh((String)config.get(ElasticSearchIndex.BULK_REFRESH, new String[0]));
        }
        Integer retryOnConflict = config.has(ElasticSearchIndex.RETRY_ON_CONFLICT, new String[0]) ? (Integer)config.get(ElasticSearchIndex.RETRY_ON_CONFLICT, new String[0]) : null;
        client.setRetryOnConflict(retryOnConflict);
        return client;
    }

    protected RestClient getRestClient(HttpHost[] hosts, Configuration config) {
        RestClientBuilder.RequestConfigCallback requestConfigCallback;
        RestClientBuilder restClientBuilder = this.getRestClientBuilder(hosts);
        RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback = this.getHttpClientConfigCallback(config);
        if (httpClientConfigCallback != null) {
            restClientBuilder.setHttpClientConfigCallback(httpClientConfigCallback);
        }
        if ((requestConfigCallback = this.getRequestConfigCallback(config)) != null) {
            restClientBuilder.setRequestConfigCallback(requestConfigCallback);
        }
        return restClientBuilder.build();
    }

    protected RestClientBuilder getRestClientBuilder(HttpHost[] hosts) {
        return RestClient.builder((HttpHost[])hosts);
    }

    protected RestElasticSearchClient getElasticSearchClient(RestClient rc, int scrollKeepAlive, boolean useMappingTypesForES7, int retryAttemptLimit, Set<Integer> retryOnErrorCodes, long retryInitialWaitMs, long retryMaxWaitMs, int bulkChunkSerializedLimit) {
        return new RestElasticSearchClient(rc, scrollKeepAlive, useMappingTypesForES7, retryAttemptLimit, retryOnErrorCodes, retryInitialWaitMs, retryMaxWaitMs, bulkChunkSerializedLimit);
    }

    protected RestClientBuilder.RequestConfigCallback getRequestConfigCallback(Configuration config) {
        LinkedList<RestClientBuilder.RequestConfigCallback> callbackList = new LinkedList<RestClientBuilder.RequestConfigCallback>();
        Integer connectTimeout = (Integer)config.get(ElasticSearchIndex.CONNECT_TIMEOUT, new String[0]);
        Integer socketTimeout = (Integer)config.get(ElasticSearchIndex.SOCKET_TIMEOUT, new String[0]);
        callbackList.add(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(connectTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()));
        return requestConfigBuilder -> {
            for (RestClientBuilder.RequestConfigCallback cb : callbackList) {
                cb.customizeRequestConfig(requestConfigBuilder);
            }
            return requestConfigBuilder;
        };
    }

    protected RestClientBuilder.HttpClientConfigCallback getHttpClientConfigCallback(Configuration config) {
        LinkedList<Object> callbackList = new LinkedList<Object>();
        HttpAuthTypes authType = (HttpAuthTypes)ConfigOption.getEnumValue((String)((String)config.get(ElasticSearchIndex.ES_HTTP_AUTH_TYPE, new String[0])), HttpAuthTypes.class);
        log.debug("Configuring HTTP(S) authentication type {}", (Object)authType);
        switch (authType) {
            case BASIC: {
                callbackList.add(new BasicAuthHttpClientConfigCallback(config.has(ElasticSearchIndex.ES_HTTP_AUTH_REALM, new String[0]) ? (String)config.get(ElasticSearchIndex.ES_HTTP_AUTH_REALM, new String[0]) : "", (String)config.get(ElasticSearchIndex.ES_HTTP_AUTH_USERNAME, new String[0]), (String)config.get(ElasticSearchIndex.ES_HTTP_AUTH_PASSWORD, new String[0])));
                break;
            }
            case CUSTOM: {
                callbackList.add(this.getCustomAuthenticator((String)config.get(ElasticSearchIndex.ES_HTTP_AUTHENTICATOR_CLASS, new String[0]), (String[])config.get(ElasticSearchIndex.ES_HTTP_AUTHENTICATOR_ARGS, new String[0])));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Authentication type \"" + (Object)((Object)authType) + "\" is not implemented");
            }
        }
        if (config.has(ElasticSearchIndex.CLIENT_KEEP_ALIVE, new String[0])) {
            callbackList.add(new ConnectionKeepAliveConfigCallback((Long)config.get(ElasticSearchIndex.CLIENT_KEEP_ALIVE, new String[0])));
        }
        if (((Boolean)config.get(ElasticSearchIndex.SSL_ENABLED, new String[0])).booleanValue()) {
            SSLConfigurationCallback.Builder sslConfCBBuilder = this.getSSLConfigurationCallbackBuilder();
            boolean configureSSL = false;
            if (config.has(ElasticSearchIndex.SSL_TRUSTSTORE_LOCATION, new String[0])) {
                sslConfCBBuilder.withTrustStore((String)config.get(ElasticSearchIndex.SSL_TRUSTSTORE_LOCATION, new String[0]), (String)config.get(ElasticSearchIndex.SSL_TRUSTSTORE_PASSWORD, new String[0]));
                configureSSL = true;
            }
            if (config.has(ElasticSearchIndex.SSL_KEYSTORE_LOCATION, new String[0])) {
                String keystorePassword = (String)config.get(ElasticSearchIndex.SSL_KEYSTORE_PASSWORD, new String[0]);
                sslConfCBBuilder.withKeyStore((String)config.get(ElasticSearchIndex.SSL_KEYSTORE_LOCATION, new String[0]), keystorePassword, config.has(ElasticSearchIndex.SSL_KEY_PASSWORD, new String[0]) ? (String)config.get(ElasticSearchIndex.SSL_KEY_PASSWORD, new String[0]) : keystorePassword);
                configureSSL = true;
            }
            if (config.has(ElasticSearchIndex.SSL_DISABLE_HOSTNAME_VERIFICATION, new String[0]) && ((Boolean)config.get(ElasticSearchIndex.SSL_DISABLE_HOSTNAME_VERIFICATION, new String[0])).booleanValue()) {
                log.warn("SSL hostname verification is disabled, Elasticsearch HTTPS connections may not be secure");
                sslConfCBBuilder.disableHostNameVerification();
                configureSSL = true;
            }
            if (config.has(ElasticSearchIndex.SSL_ALLOW_SELF_SIGNED_CERTIFICATES, new String[0]) && ((Boolean)config.get(ElasticSearchIndex.SSL_ALLOW_SELF_SIGNED_CERTIFICATES, new String[0])).booleanValue()) {
                log.warn("Self-signed SSL certificate support is enabled, Elasticsearch HTTPS connections may not be secure");
                sslConfCBBuilder.allowSelfSignedCertificates();
                configureSSL = true;
            }
            if (configureSSL) {
                callbackList.add(sslConfCBBuilder.build());
            }
        }
        if (callbackList.isEmpty()) {
            return null;
        }
        return httpClientBuilder -> {
            for (RestClientBuilder.HttpClientConfigCallback cb : callbackList) {
                cb.customizeHttpClient(httpClientBuilder);
            }
            return httpClientBuilder;
        };
    }

    protected SSLConfigurationCallback.Builder getSSLConfigurationCallbackBuilder() {
        return SSLConfigurationCallback.Builder.create();
    }

    protected RestClientAuthenticator getCustomAuthenticator(String authClassName, String[] authClassConstructorArgList) {
        RestClientAuthenticator authenticator;
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)authClassName), (Object)"Custom authenticator class name cannot be empty");
        Preconditions.checkNotNull((Object)authClassConstructorArgList, (Object)"Custom authenticator class constructor argument list cannot be null");
        try {
            Class<?> c = Class.forName(authClassName);
            Preconditions.checkArgument((boolean)RestClientAuthenticator.class.isAssignableFrom(c), (String)"Authenticator class %s must be a subclass of %s", (Object)authClassName, (Object)RestClientAuthenticator.class.getName());
            Constructor<?> ctr = c.getConstructor(String[].class);
            authenticator = (RestClientAuthenticator)ctr.newInstance(new Object[]{authClassConstructorArgList});
        }
        catch (Exception e) {
            log.error("Unable to instantiate the custom authenticator {} with constructor arguments \"{}\"", new Object[]{authClassName, authClassConstructorArgList, e});
            throw new RuntimeException("Unable to instantiate the custom authenticator", e);
        }
        try {
            authenticator.init();
        }
        catch (IOException e) {
            log.error("Unable to initialize the custom authenticator {} with constructor arguments \"{}\"", new Object[]{authClassName, authClassConstructorArgList, e});
            throw new RuntimeException("Unable to initialize the custom authenticator", e);
        }
        return authenticator;
    }
}

