/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es.rest.util;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClientBuilder;

public class BasicAuthHttpClientConfigCallback
implements RestClientBuilder.HttpClientConfigCallback {
    private final CredentialsProvider credentialsProvider;

    public BasicAuthHttpClientConfigCallback(String realm, String username, String password) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)username), (Object)"HTTP Basic Authentication: username must be provided");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)password), (Object)"HTTP Basic Authentication: password must be provided");
        this.credentialsProvider = new BasicCredentialsProvider();
        AuthScope authScope = StringUtils.isNotEmpty((CharSequence)realm) ? new AuthScope(AuthScope.ANY_HOST, -1, realm, AuthScope.ANY_SCHEME) : AuthScope.ANY;
        this.credentialsProvider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setDefaultCredentialsProvider(this.credentialsProvider);
        return httpClientBuilder;
    }
}

