/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.BaseConfiguration;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.graphdb.olap.job.IndexRemoveJob;
import org.janusgraph.graphdb.olap.job.IndexRepairJob;
import org.janusgraph.graphdb.olap.job.IndexUpdateJob;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.scan.CassandraHadoopScanRunner;
import org.janusgraph.hadoop.scan.HBaseHadoopScanRunner;
import org.janusgraph.util.system.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceIndexJobs {
    private static final Logger log = LoggerFactory.getLogger(MapReduceIndexJobs.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanMetrics cassandraRepair(String janusgraphPropertiesPath, String indexName, String relationType, String partitionerName) throws InterruptedException, IOException, ClassNotFoundException {
        ScanMetrics scanMetrics;
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(janusgraphPropertiesPath);
            p.load(fis);
            scanMetrics = MapReduceIndexJobs.cassandraRepair(p, indexName, relationType, partitionerName);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fis);
        return scanMetrics;
    }

    public static ScanMetrics cassandraRepair(Properties janusgraphProperties, String indexName, String relationType, String partitionerName) throws InterruptedException, IOException, ClassNotFoundException {
        return MapReduceIndexJobs.cassandraRepair(janusgraphProperties, indexName, relationType, partitionerName, new org.apache.hadoop.conf.Configuration());
    }

    public static ScanMetrics cassandraRepair(Properties janusgraphProperties, String indexName, String relationType, String partitionerName, org.apache.hadoop.conf.Configuration hadoopBaseConf) throws InterruptedException, IOException, ClassNotFoundException {
        IndexRepairJob job = new IndexRepairJob();
        CassandraHadoopScanRunner cr = new CassandraHadoopScanRunner((VertexScanJob)job);
        ModifiableConfiguration mc = MapReduceIndexJobs.getIndexJobConf(indexName, relationType);
        MapReduceIndexJobs.copyPropertiesToInputAndOutputConf(hadoopBaseConf, janusgraphProperties);
        cr.partitionerOverride(partitionerName);
        cr.scanJobConf((Configuration)mc);
        cr.scanJobConfRoot(GraphDatabaseConfiguration.class.getName() + "#JOB_NS");
        cr.baseHadoopConf(hadoopBaseConf);
        return cr.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanMetrics cassandraRemove(String janusgraphPropertiesPath, String indexName, String relationType, String partitionerName) throws InterruptedException, IOException, ClassNotFoundException {
        ScanMetrics scanMetrics;
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(janusgraphPropertiesPath);
            p.load(fis);
            scanMetrics = MapReduceIndexJobs.cassandraRemove(p, indexName, relationType, partitionerName);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fis);
        return scanMetrics;
    }

    public static ScanMetrics cassandraRemove(Properties janusgraphProperties, String indexName, String relationType, String partitionerName) throws InterruptedException, IOException, ClassNotFoundException {
        return MapReduceIndexJobs.cassandraRemove(janusgraphProperties, indexName, relationType, partitionerName, new org.apache.hadoop.conf.Configuration());
    }

    public static ScanMetrics cassandraRemove(Properties janusgraphProperties, String indexName, String relationType, String partitionerName, org.apache.hadoop.conf.Configuration hadoopBaseConf) throws InterruptedException, IOException, ClassNotFoundException {
        IndexRemoveJob job = new IndexRemoveJob();
        CassandraHadoopScanRunner cr = new CassandraHadoopScanRunner((ScanJob)job);
        ModifiableConfiguration mc = MapReduceIndexJobs.getIndexJobConf(indexName, relationType);
        MapReduceIndexJobs.copyPropertiesToInputAndOutputConf(hadoopBaseConf, janusgraphProperties);
        cr.partitionerOverride(partitionerName);
        cr.scanJobConf((Configuration)mc);
        cr.scanJobConfRoot(GraphDatabaseConfiguration.class.getName() + "#JOB_NS");
        cr.baseHadoopConf(hadoopBaseConf);
        return cr.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanMetrics hbaseRepair(String janusgraphPropertiesPath, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        ScanMetrics scanMetrics;
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(janusgraphPropertiesPath);
            p.load(fis);
            scanMetrics = MapReduceIndexJobs.hbaseRepair(p, indexName, relationType);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fis);
        return scanMetrics;
    }

    public static ScanMetrics hbaseRepair(Properties janusgraphProperties, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        return MapReduceIndexJobs.hbaseRepair(janusgraphProperties, indexName, relationType, new org.apache.hadoop.conf.Configuration());
    }

    public static ScanMetrics hbaseRepair(Properties janusgraphProperties, String indexName, String relationType, org.apache.hadoop.conf.Configuration hadoopBaseConf) throws InterruptedException, IOException, ClassNotFoundException {
        IndexRepairJob job = new IndexRepairJob();
        HBaseHadoopScanRunner cr = new HBaseHadoopScanRunner((VertexScanJob)job);
        ModifiableConfiguration mc = MapReduceIndexJobs.getIndexJobConf(indexName, relationType);
        MapReduceIndexJobs.copyPropertiesToInputAndOutputConf(hadoopBaseConf, janusgraphProperties);
        cr.scanJobConf((Configuration)mc);
        cr.scanJobConfRoot(GraphDatabaseConfiguration.class.getName() + "#JOB_NS");
        cr.baseHadoopConf(hadoopBaseConf);
        return cr.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanMetrics hbaseRemove(String janusgraphPropertiesPath, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        ScanMetrics scanMetrics;
        Properties p = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(janusgraphPropertiesPath);
            p.load(fis);
            scanMetrics = MapReduceIndexJobs.hbaseRemove(p, indexName, relationType);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fis);
        return scanMetrics;
    }

    public static ScanMetrics hbaseRemove(Properties janusgraphProperties, String indexName, String relationType) throws InterruptedException, IOException, ClassNotFoundException {
        return MapReduceIndexJobs.hbaseRemove(janusgraphProperties, indexName, relationType, new org.apache.hadoop.conf.Configuration());
    }

    public static ScanMetrics hbaseRemove(Properties janusgraphProperties, String indexName, String relationType, org.apache.hadoop.conf.Configuration hadoopBaseConf) throws InterruptedException, IOException, ClassNotFoundException {
        IndexRemoveJob job = new IndexRemoveJob();
        HBaseHadoopScanRunner cr = new HBaseHadoopScanRunner((ScanJob)job);
        ModifiableConfiguration mc = MapReduceIndexJobs.getIndexJobConf(indexName, relationType);
        MapReduceIndexJobs.copyPropertiesToInputAndOutputConf(hadoopBaseConf, janusgraphProperties);
        cr.scanJobConf((Configuration)mc);
        cr.scanJobConfRoot(GraphDatabaseConfiguration.class.getName() + "#JOB_NS");
        cr.baseHadoopConf(hadoopBaseConf);
        return cr.run();
    }

    private static ModifiableConfiguration getIndexJobConf(String indexName, String relationType) {
        ModifiableConfiguration mc = new ModifiableConfiguration(GraphDatabaseConfiguration.JOB_NS, (WriteConfiguration)new CommonsConfiguration((org.apache.commons.configuration.Configuration)new BaseConfiguration()), BasicConfiguration.Restriction.NONE);
        mc.set(IndexUpdateJob.INDEX_NAME, (Object)indexName, new String[0]);
        mc.set(IndexUpdateJob.INDEX_RELATION_TYPE, (Object)relationType, new String[0]);
        mc.set(GraphDatabaseConfiguration.JOB_START_TIME, (Object)System.currentTimeMillis(), new String[0]);
        return mc;
    }

    private static void copyPropertiesToInputAndOutputConf(org.apache.hadoop.conf.Configuration sink, Properties source) {
        String prefix = ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".";
        for (Map.Entry<Object, Object> e : source.entrySet()) {
            String v = e.getValue().toString();
            String k = prefix + e.getKey().toString();
            sink.set(k, v);
            log.info("Set {}={}", (Object)k, (Object)v);
        }
    }
}

