/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.formats.cassandra;

import java.io.IOException;
import java.util.List;
import org.apache.cassandra.hadoop.ColumnFamilyInputFormat;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.cassandra.AbstractCassandraStoreManager;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.formats.cassandra.CassandraBinaryRecordReader;
import org.janusgraph.hadoop.formats.util.AbstractBinaryInputFormat;
import org.janusgraph.hadoop.formats.util.input.JanusGraphHadoopSetupCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraBinaryInputFormat
extends AbstractBinaryInputFormat {
    private static final Logger log = LoggerFactory.getLogger(CassandraBinaryInputFormat.class);
    private static final String INPUT_WIDEROWS_CONFIG = "cassandra.input.widerows";
    private static final String RANGE_BATCH_SIZE_CONFIG = "cassandra.range.batch.size";
    private final ColumnFamilyInputFormat columnFamilyInputFormat = new ColumnFamilyInputFormat();
    RecordReader<StaticBuffer, Iterable<Entry>> janusgraphRecordReader;

    public RecordReader<StaticBuffer, Iterable<Entry>> getRecordReader() {
        return this.janusgraphRecordReader;
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.columnFamilyInputFormat.getSplits(jobContext);
    }

    public RecordReader<StaticBuffer, Iterable<Entry>> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.janusgraphRecordReader = new CassandraBinaryRecordReader((ColumnFamilyRecordReader)this.columnFamilyInputFormat.createRecordReader(inputSplit, taskAttemptContext));
        return this.janusgraphRecordReader;
    }

    @Override
    public void setConf(Configuration config) {
        super.setConf(config);
        ConfigHelper.setInputInitialAddress((Configuration)config, (String)((String[])this.janusgraphConf.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0]))[0]);
        if (this.janusgraphConf.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])) {
            ConfigHelper.setInputRpcPort((Configuration)config, (String)String.valueOf(this.janusgraphConf.get(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])));
        }
        if (this.janusgraphConf.has(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0])) {
            ConfigHelper.setInputKeyspaceUserName((Configuration)config, (String)((String)this.janusgraphConf.get(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0])));
        }
        if (this.janusgraphConf.has(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0])) {
            ConfigHelper.setInputKeyspacePassword((Configuration)config, (String)((String)this.janusgraphConf.get(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0])));
        }
        boolean wideRows = config.getBoolean(INPUT_WIDEROWS_CONFIG, false);
        ConfigHelper.setInputColumnFamily((Configuration)config, (String)((String)this.janusgraphConf.get(AbstractCassandraStoreManager.CASSANDRA_KEYSPACE, new String[0])), (String)((String)this.mrConf.get(JanusGraphHadoopConfiguration.COLUMN_FAMILY_NAME, new String[0])), (boolean)wideRows);
        log.debug("Set keyspace: {}", this.janusgraphConf.get(AbstractCassandraStoreManager.CASSANDRA_KEYSPACE, new String[0]));
        SlicePredicate predicate = new SlicePredicate();
        int rangeBatchSize = config.getInt(RANGE_BATCH_SIZE_CONFIG, Integer.MAX_VALUE);
        predicate.setSlice_range(this.getSliceRange(rangeBatchSize));
        ConfigHelper.setInputSlicePredicate((Configuration)config, (SlicePredicate)predicate);
    }

    private SliceRange getSliceRange(int limit) {
        SliceRange sliceRange = new SliceRange();
        sliceRange.setStart(JanusGraphHadoopSetupCommon.DEFAULT_SLICE_QUERY.getSliceStart().asByteBuffer());
        sliceRange.setFinish(JanusGraphHadoopSetupCommon.DEFAULT_SLICE_QUERY.getSliceEnd().asByteBuffer());
        sliceRange.setCount(Math.min(limit, JanusGraphHadoopSetupCommon.DEFAULT_SLICE_QUERY.getLimit()));
        return sliceRange;
    }
}

