/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.scan;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.formats.hbase.HBaseBinaryInputFormat;
import org.janusgraph.hadoop.scan.AbstractHadoopScanRunner;
import org.janusgraph.hadoop.scan.HadoopScanRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseHadoopScanRunner
extends AbstractHadoopScanRunner<HBaseHadoopScanRunner> {
    private static final Logger log = LoggerFactory.getLogger(HBaseHadoopScanRunner.class);

    public HBaseHadoopScanRunner(ScanJob scanJob) {
        super(scanJob);
    }

    public HBaseHadoopScanRunner(VertexScanJob vertexScanJob) {
        super(vertexScanJob);
    }

    @Override
    protected HBaseHadoopScanRunner self() {
        return this;
    }

    public ScanMetrics run() throws InterruptedException, IOException, ClassNotFoundException {
        Configuration hadoopConf;
        Configuration configuration = hadoopConf = null != this.baseHadoopConf ? this.baseHadoopConf : new Configuration();
        if (null != this.janusgraphConf) {
            String prefix = ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".";
            for (String k : this.janusgraphConf.getKeys("")) {
                hadoopConf.set(prefix + k, this.janusgraphConf.get(k, Object.class).toString());
                log.debug("Set: {}={}", (Object)(prefix + k), (Object)this.janusgraphConf.get(k, Object.class).toString());
            }
        }
        Preconditions.checkNotNull((Object)hadoopConf);
        if (null != this.scanJob) {
            return HadoopScanRunner.runScanJob(this.scanJob, this.scanJobConf, this.scanJobConfRoot, hadoopConf, HBaseBinaryInputFormat.class);
        }
        return HadoopScanRunner.runVertexScanJob(this.vertexScanJob, this.scanJobConf, this.scanJobConfRoot, hadoopConf, HBaseBinaryInputFormat.class);
    }
}

