/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.scan;

import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.hadoop.compat.HadoopCompatLoader;

public class HadoopContextScanMetrics
implements ScanMetrics {
    private final TaskInputOutputContext taskIOCtx;
    public static final String CUSTOM_COUNTER_GROUP = "ScanJob.Custom";
    public static final String STANDARD_COUNTER_GROUP = "ScanJob.Standard";

    public HadoopContextScanMetrics(TaskInputOutputContext taskIOCtx) {
        this.taskIOCtx = taskIOCtx;
    }

    public long getCustom(String metric) {
        return HadoopCompatLoader.DEFAULT_COMPAT.getContextCounter(this.taskIOCtx, CUSTOM_COUNTER_GROUP, metric);
    }

    public void incrementCustom(String metric, long delta) {
        HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter(this.taskIOCtx, CUSTOM_COUNTER_GROUP, metric, delta);
    }

    public void incrementCustom(String metric) {
        this.incrementCustom(metric, 1L);
    }

    public long get(ScanMetrics.Metric metric) {
        return HadoopCompatLoader.DEFAULT_COMPAT.getContextCounter(this.taskIOCtx, STANDARD_COUNTER_GROUP, metric.name());
    }

    public void increment(ScanMetrics.Metric metric) {
        HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter(this.taskIOCtx, STANDARD_COUNTER_GROUP, metric.name(), 1L);
    }
}

