/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop.config;

import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.hadoop.config.HadoopConfiguration;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;

public class ModifiableHadoopConfiguration
extends ModifiableConfiguration {
    private final Configuration conf;

    private ModifiableHadoopConfiguration(ConfigNamespace root, Configuration c) {
        super(root, (WriteConfiguration)new HadoopConfiguration(c), BasicConfiguration.Restriction.NONE);
        this.conf = c;
    }

    public static ModifiableHadoopConfiguration of(ConfigNamespace root, Configuration c) {
        Preconditions.checkNotNull((Object)c);
        return new ModifiableHadoopConfiguration(root, c);
    }

    public static ModifiableConfiguration prefixView(ConfigNamespace newRoot, ConfigNamespace prefixRoot, ModifiableHadoopConfiguration mc) {
        HadoopConfiguration prefixConf = new HadoopConfiguration(mc.getHadoopConfiguration(), ConfigElement.getPath((ConfigElement)prefixRoot, (boolean)true, (String[])new String[0]) + ".");
        return new ModifiableConfiguration(newRoot, (WriteConfiguration)prefixConf, BasicConfiguration.Restriction.NONE);
    }

    public Configuration getHadoopConfiguration() {
        return this.conf;
    }

    public ModifiableConfiguration getJanusGraphConf() {
        return ModifiableHadoopConfiguration.prefixView(GraphDatabaseConfiguration.ROOT_NS, JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, this);
    }
}

